//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AdvancedThreatProtectionProperties.
func (a AdvancedThreatProtectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvancedThreatProtectionProperties.
func (a *AdvancedThreatProtectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Advisor.
func (a Advisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AdvisorProperties.
func (a AdvisorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "advisorStatus", a.AdvisorStatus)
	populate(objectMap, "autoExecuteStatus", a.AutoExecuteStatus)
	populate(objectMap, "autoExecuteStatusInheritedFrom", a.AutoExecuteStatusInheritedFrom)
	populateTimeRFC3339(objectMap, "lastChecked", a.LastChecked)
	populate(objectMap, "recommendationsStatus", a.RecommendationsStatus)
	populate(objectMap, "recommendedActions", a.RecommendedActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvisorProperties.
func (a *AdvisorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advisorStatus":
			err = unpopulate(val, "AdvisorStatus", &a.AdvisorStatus)
			delete(rawMsg, key)
		case "autoExecuteStatus":
			err = unpopulate(val, "AutoExecuteStatus", &a.AutoExecuteStatus)
			delete(rawMsg, key)
		case "autoExecuteStatusInheritedFrom":
			err = unpopulate(val, "AutoExecuteStatusInheritedFrom", &a.AutoExecuteStatusInheritedFrom)
			delete(rawMsg, key)
		case "lastChecked":
			err = unpopulateTimeRFC3339(val, "LastChecked", &a.LastChecked)
			delete(rawMsg, key)
		case "recommendationsStatus":
			err = unpopulate(val, "RecommendationsStatus", &a.RecommendationsStatus)
			delete(rawMsg, key)
		case "recommendedActions":
			err = unpopulate(val, "RecommendedActions", &a.RecommendedActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticTuningServerProperties.
func (a AutomaticTuningServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actualState", a.ActualState)
	populate(objectMap, "desiredState", a.DesiredState)
	populate(objectMap, "options", a.Options)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupShortTermRetentionPolicy.
func (b BackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseAutomaticTuning.
func (d DatabaseAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseAutomaticTuningProperties.
func (d DatabaseAutomaticTuningProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actualState", d.ActualState)
	populate(objectMap, "desiredState", d.DesiredState)
	populate(objectMap, "options", d.Options)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseBlobAuditingPolicyProperties.
func (d DatabaseBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", d.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", d.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isManagedIdentityInUse", d.IsManagedIdentityInUse)
	populate(objectMap, "isStorageSecondaryKeyInUse", d.IsStorageSecondaryKeyInUse)
	populate(objectMap, "queueDelayMs", d.QueueDelayMs)
	populate(objectMap, "retentionDays", d.RetentionDays)
	populate(objectMap, "state", d.State)
	populate(objectMap, "storageAccountAccessKey", d.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", d.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", d.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseIdentity.
func (d DatabaseIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tenantId", d.TenantID)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "userAssignedIdentities", d.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseOperationProperties.
func (d DatabaseOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", d.DatabaseName)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "errorCode", d.ErrorCode)
	populate(objectMap, "errorDescription", d.ErrorDescription)
	populate(objectMap, "errorSeverity", d.ErrorSeverity)
	populateTimeRFC3339(objectMap, "estimatedCompletionTime", d.EstimatedCompletionTime)
	populate(objectMap, "isCancellable", d.IsCancellable)
	populate(objectMap, "isUserError", d.IsUserError)
	populate(objectMap, "operation", d.Operation)
	populate(objectMap, "operationFriendlyName", d.OperationFriendlyName)
	populate(objectMap, "percentComplete", d.PercentComplete)
	populate(objectMap, "serverName", d.ServerName)
	populateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "state", d.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseOperationProperties.
func (d *DatabaseOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &d.DatabaseName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &d.ErrorCode)
			delete(rawMsg, key)
		case "errorDescription":
			err = unpopulate(val, "ErrorDescription", &d.ErrorDescription)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &d.ErrorSeverity)
			delete(rawMsg, key)
		case "estimatedCompletionTime":
			err = unpopulateTimeRFC3339(val, "EstimatedCompletionTime", &d.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &d.IsCancellable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &d.IsUserError)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &d.Operation)
			delete(rawMsg, key)
		case "operationFriendlyName":
			err = unpopulate(val, "OperationFriendlyName", &d.OperationFriendlyName)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &d.PercentComplete)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &d.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseProperties.
func (d DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoPauseDelay", d.AutoPauseDelay)
	populate(objectMap, "catalogCollation", d.CatalogCollation)
	populate(objectMap, "collation", d.Collation)
	populate(objectMap, "createMode", d.CreateMode)
	populateTimeRFC3339(objectMap, "creationDate", d.CreationDate)
	populate(objectMap, "currentBackupStorageRedundancy", d.CurrentBackupStorageRedundancy)
	populate(objectMap, "currentSku", d.CurrentSKU)
	populate(objectMap, "currentServiceObjectiveName", d.CurrentServiceObjectiveName)
	populate(objectMap, "databaseId", d.DatabaseID)
	populate(objectMap, "defaultSecondaryLocation", d.DefaultSecondaryLocation)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", d.EarliestRestoreDate)
	populate(objectMap, "elasticPoolId", d.ElasticPoolID)
	populate(objectMap, "failoverGroupId", d.FailoverGroupID)
	populate(objectMap, "federatedClientId", d.FederatedClientID)
	populate(objectMap, "highAvailabilityReplicaCount", d.HighAvailabilityReplicaCount)
	populate(objectMap, "isInfraEncryptionEnabled", d.IsInfraEncryptionEnabled)
	populate(objectMap, "isLedgerOn", d.IsLedgerOn)
	populate(objectMap, "licenseType", d.LicenseType)
	populate(objectMap, "longTermRetentionBackupResourceId", d.LongTermRetentionBackupResourceID)
	populate(objectMap, "maintenanceConfigurationId", d.MaintenanceConfigurationID)
	populate(objectMap, "maxLogSizeBytes", d.MaxLogSizeBytes)
	populate(objectMap, "maxSizeBytes", d.MaxSizeBytes)
	populate(objectMap, "minCapacity", d.MinCapacity)
	populateTimeRFC3339(objectMap, "pausedDate", d.PausedDate)
	populate(objectMap, "readScale", d.ReadScale)
	populate(objectMap, "recoverableDatabaseId", d.RecoverableDatabaseID)
	populate(objectMap, "recoveryServicesRecoveryPointId", d.RecoveryServicesRecoveryPointID)
	populate(objectMap, "requestedBackupStorageRedundancy", d.RequestedBackupStorageRedundancy)
	populate(objectMap, "requestedServiceObjectiveName", d.RequestedServiceObjectiveName)
	populate(objectMap, "restorableDroppedDatabaseId", d.RestorableDroppedDatabaseID)
	populateTimeRFC3339(objectMap, "restorePointInTime", d.RestorePointInTime)
	populateTimeRFC3339(objectMap, "resumedDate", d.ResumedDate)
	populate(objectMap, "sampleName", d.SampleName)
	populate(objectMap, "secondaryType", d.SecondaryType)
	populateTimeRFC3339(objectMap, "sourceDatabaseDeletionDate", d.SourceDatabaseDeletionDate)
	populate(objectMap, "sourceDatabaseId", d.SourceDatabaseID)
	populate(objectMap, "sourceResourceId", d.SourceResourceID)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "zoneRedundant", d.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseProperties.
func (d *DatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoPauseDelay":
			err = unpopulate(val, "AutoPauseDelay", &d.AutoPauseDelay)
			delete(rawMsg, key)
		case "catalogCollation":
			err = unpopulate(val, "CatalogCollation", &d.CatalogCollation)
			delete(rawMsg, key)
		case "collation":
			err = unpopulate(val, "Collation", &d.Collation)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &d.CreateMode)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &d.CreationDate)
			delete(rawMsg, key)
		case "currentBackupStorageRedundancy":
			err = unpopulate(val, "CurrentBackupStorageRedundancy", &d.CurrentBackupStorageRedundancy)
			delete(rawMsg, key)
		case "currentSku":
			err = unpopulate(val, "CurrentSKU", &d.CurrentSKU)
			delete(rawMsg, key)
		case "currentServiceObjectiveName":
			err = unpopulate(val, "CurrentServiceObjectiveName", &d.CurrentServiceObjectiveName)
			delete(rawMsg, key)
		case "databaseId":
			err = unpopulate(val, "DatabaseID", &d.DatabaseID)
			delete(rawMsg, key)
		case "defaultSecondaryLocation":
			err = unpopulate(val, "DefaultSecondaryLocation", &d.DefaultSecondaryLocation)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &d.EarliestRestoreDate)
			delete(rawMsg, key)
		case "elasticPoolId":
			err = unpopulate(val, "ElasticPoolID", &d.ElasticPoolID)
			delete(rawMsg, key)
		case "failoverGroupId":
			err = unpopulate(val, "FailoverGroupID", &d.FailoverGroupID)
			delete(rawMsg, key)
		case "federatedClientId":
			err = unpopulate(val, "FederatedClientID", &d.FederatedClientID)
			delete(rawMsg, key)
		case "highAvailabilityReplicaCount":
			err = unpopulate(val, "HighAvailabilityReplicaCount", &d.HighAvailabilityReplicaCount)
			delete(rawMsg, key)
		case "isInfraEncryptionEnabled":
			err = unpopulate(val, "IsInfraEncryptionEnabled", &d.IsInfraEncryptionEnabled)
			delete(rawMsg, key)
		case "isLedgerOn":
			err = unpopulate(val, "IsLedgerOn", &d.IsLedgerOn)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &d.LicenseType)
			delete(rawMsg, key)
		case "longTermRetentionBackupResourceId":
			err = unpopulate(val, "LongTermRetentionBackupResourceID", &d.LongTermRetentionBackupResourceID)
			delete(rawMsg, key)
		case "maintenanceConfigurationId":
			err = unpopulate(val, "MaintenanceConfigurationID", &d.MaintenanceConfigurationID)
			delete(rawMsg, key)
		case "maxLogSizeBytes":
			err = unpopulate(val, "MaxLogSizeBytes", &d.MaxLogSizeBytes)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &d.MaxSizeBytes)
			delete(rawMsg, key)
		case "minCapacity":
			err = unpopulate(val, "MinCapacity", &d.MinCapacity)
			delete(rawMsg, key)
		case "pausedDate":
			err = unpopulateTimeRFC3339(val, "PausedDate", &d.PausedDate)
			delete(rawMsg, key)
		case "readScale":
			err = unpopulate(val, "ReadScale", &d.ReadScale)
			delete(rawMsg, key)
		case "recoverableDatabaseId":
			err = unpopulate(val, "RecoverableDatabaseID", &d.RecoverableDatabaseID)
			delete(rawMsg, key)
		case "recoveryServicesRecoveryPointId":
			err = unpopulate(val, "RecoveryServicesRecoveryPointID", &d.RecoveryServicesRecoveryPointID)
			delete(rawMsg, key)
		case "requestedBackupStorageRedundancy":
			err = unpopulate(val, "RequestedBackupStorageRedundancy", &d.RequestedBackupStorageRedundancy)
			delete(rawMsg, key)
		case "requestedServiceObjectiveName":
			err = unpopulate(val, "RequestedServiceObjectiveName", &d.RequestedServiceObjectiveName)
			delete(rawMsg, key)
		case "restorableDroppedDatabaseId":
			err = unpopulate(val, "RestorableDroppedDatabaseID", &d.RestorableDroppedDatabaseID)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &d.RestorePointInTime)
			delete(rawMsg, key)
		case "resumedDate":
			err = unpopulateTimeRFC3339(val, "ResumedDate", &d.ResumedDate)
			delete(rawMsg, key)
		case "sampleName":
			err = unpopulate(val, "SampleName", &d.SampleName)
			delete(rawMsg, key)
		case "secondaryType":
			err = unpopulate(val, "SecondaryType", &d.SecondaryType)
			delete(rawMsg, key)
		case "sourceDatabaseDeletionDate":
			err = unpopulateTimeRFC3339(val, "SourceDatabaseDeletionDate", &d.SourceDatabaseDeletionDate)
			delete(rawMsg, key)
		case "sourceDatabaseId":
			err = unpopulate(val, "SourceDatabaseID", &d.SourceDatabaseID)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &d.SourceResourceID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &d.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseUpdate.
func (d DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseUpdateProperties.
func (d DatabaseUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoPauseDelay", d.AutoPauseDelay)
	populate(objectMap, "catalogCollation", d.CatalogCollation)
	populate(objectMap, "collation", d.Collation)
	populate(objectMap, "createMode", d.CreateMode)
	populateTimeRFC3339(objectMap, "creationDate", d.CreationDate)
	populate(objectMap, "currentBackupStorageRedundancy", d.CurrentBackupStorageRedundancy)
	populate(objectMap, "currentSku", d.CurrentSKU)
	populate(objectMap, "currentServiceObjectiveName", d.CurrentServiceObjectiveName)
	populate(objectMap, "databaseId", d.DatabaseID)
	populate(objectMap, "defaultSecondaryLocation", d.DefaultSecondaryLocation)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", d.EarliestRestoreDate)
	populate(objectMap, "elasticPoolId", d.ElasticPoolID)
	populate(objectMap, "failoverGroupId", d.FailoverGroupID)
	populate(objectMap, "federatedClientId", d.FederatedClientID)
	populate(objectMap, "highAvailabilityReplicaCount", d.HighAvailabilityReplicaCount)
	populate(objectMap, "isInfraEncryptionEnabled", d.IsInfraEncryptionEnabled)
	populate(objectMap, "isLedgerOn", d.IsLedgerOn)
	populate(objectMap, "licenseType", d.LicenseType)
	populate(objectMap, "longTermRetentionBackupResourceId", d.LongTermRetentionBackupResourceID)
	populate(objectMap, "maintenanceConfigurationId", d.MaintenanceConfigurationID)
	populate(objectMap, "maxLogSizeBytes", d.MaxLogSizeBytes)
	populate(objectMap, "maxSizeBytes", d.MaxSizeBytes)
	populate(objectMap, "minCapacity", d.MinCapacity)
	populateTimeRFC3339(objectMap, "pausedDate", d.PausedDate)
	populate(objectMap, "readScale", d.ReadScale)
	populate(objectMap, "recoverableDatabaseId", d.RecoverableDatabaseID)
	populate(objectMap, "recoveryServicesRecoveryPointId", d.RecoveryServicesRecoveryPointID)
	populate(objectMap, "requestedBackupStorageRedundancy", d.RequestedBackupStorageRedundancy)
	populate(objectMap, "requestedServiceObjectiveName", d.RequestedServiceObjectiveName)
	populate(objectMap, "restorableDroppedDatabaseId", d.RestorableDroppedDatabaseID)
	populateTimeRFC3339(objectMap, "restorePointInTime", d.RestorePointInTime)
	populateTimeRFC3339(objectMap, "resumedDate", d.ResumedDate)
	populate(objectMap, "sampleName", d.SampleName)
	populate(objectMap, "secondaryType", d.SecondaryType)
	populateTimeRFC3339(objectMap, "sourceDatabaseDeletionDate", d.SourceDatabaseDeletionDate)
	populate(objectMap, "sourceDatabaseId", d.SourceDatabaseID)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "zoneRedundant", d.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseUpdateProperties.
func (d *DatabaseUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoPauseDelay":
			err = unpopulate(val, "AutoPauseDelay", &d.AutoPauseDelay)
			delete(rawMsg, key)
		case "catalogCollation":
			err = unpopulate(val, "CatalogCollation", &d.CatalogCollation)
			delete(rawMsg, key)
		case "collation":
			err = unpopulate(val, "Collation", &d.Collation)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &d.CreateMode)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &d.CreationDate)
			delete(rawMsg, key)
		case "currentBackupStorageRedundancy":
			err = unpopulate(val, "CurrentBackupStorageRedundancy", &d.CurrentBackupStorageRedundancy)
			delete(rawMsg, key)
		case "currentSku":
			err = unpopulate(val, "CurrentSKU", &d.CurrentSKU)
			delete(rawMsg, key)
		case "currentServiceObjectiveName":
			err = unpopulate(val, "CurrentServiceObjectiveName", &d.CurrentServiceObjectiveName)
			delete(rawMsg, key)
		case "databaseId":
			err = unpopulate(val, "DatabaseID", &d.DatabaseID)
			delete(rawMsg, key)
		case "defaultSecondaryLocation":
			err = unpopulate(val, "DefaultSecondaryLocation", &d.DefaultSecondaryLocation)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &d.EarliestRestoreDate)
			delete(rawMsg, key)
		case "elasticPoolId":
			err = unpopulate(val, "ElasticPoolID", &d.ElasticPoolID)
			delete(rawMsg, key)
		case "failoverGroupId":
			err = unpopulate(val, "FailoverGroupID", &d.FailoverGroupID)
			delete(rawMsg, key)
		case "federatedClientId":
			err = unpopulate(val, "FederatedClientID", &d.FederatedClientID)
			delete(rawMsg, key)
		case "highAvailabilityReplicaCount":
			err = unpopulate(val, "HighAvailabilityReplicaCount", &d.HighAvailabilityReplicaCount)
			delete(rawMsg, key)
		case "isInfraEncryptionEnabled":
			err = unpopulate(val, "IsInfraEncryptionEnabled", &d.IsInfraEncryptionEnabled)
			delete(rawMsg, key)
		case "isLedgerOn":
			err = unpopulate(val, "IsLedgerOn", &d.IsLedgerOn)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &d.LicenseType)
			delete(rawMsg, key)
		case "longTermRetentionBackupResourceId":
			err = unpopulate(val, "LongTermRetentionBackupResourceID", &d.LongTermRetentionBackupResourceID)
			delete(rawMsg, key)
		case "maintenanceConfigurationId":
			err = unpopulate(val, "MaintenanceConfigurationID", &d.MaintenanceConfigurationID)
			delete(rawMsg, key)
		case "maxLogSizeBytes":
			err = unpopulate(val, "MaxLogSizeBytes", &d.MaxLogSizeBytes)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &d.MaxSizeBytes)
			delete(rawMsg, key)
		case "minCapacity":
			err = unpopulate(val, "MinCapacity", &d.MinCapacity)
			delete(rawMsg, key)
		case "pausedDate":
			err = unpopulateTimeRFC3339(val, "PausedDate", &d.PausedDate)
			delete(rawMsg, key)
		case "readScale":
			err = unpopulate(val, "ReadScale", &d.ReadScale)
			delete(rawMsg, key)
		case "recoverableDatabaseId":
			err = unpopulate(val, "RecoverableDatabaseID", &d.RecoverableDatabaseID)
			delete(rawMsg, key)
		case "recoveryServicesRecoveryPointId":
			err = unpopulate(val, "RecoveryServicesRecoveryPointID", &d.RecoveryServicesRecoveryPointID)
			delete(rawMsg, key)
		case "requestedBackupStorageRedundancy":
			err = unpopulate(val, "RequestedBackupStorageRedundancy", &d.RequestedBackupStorageRedundancy)
			delete(rawMsg, key)
		case "requestedServiceObjectiveName":
			err = unpopulate(val, "RequestedServiceObjectiveName", &d.RequestedServiceObjectiveName)
			delete(rawMsg, key)
		case "restorableDroppedDatabaseId":
			err = unpopulate(val, "RestorableDroppedDatabaseID", &d.RestorableDroppedDatabaseID)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &d.RestorePointInTime)
			delete(rawMsg, key)
		case "resumedDate":
			err = unpopulateTimeRFC3339(val, "ResumedDate", &d.ResumedDate)
			delete(rawMsg, key)
		case "sampleName":
			err = unpopulate(val, "SampleName", &d.SampleName)
			delete(rawMsg, key)
		case "secondaryType":
			err = unpopulate(val, "SecondaryType", &d.SecondaryType)
			delete(rawMsg, key)
		case "sourceDatabaseDeletionDate":
			err = unpopulateTimeRFC3339(val, "SourceDatabaseDeletionDate", &d.SourceDatabaseDeletionDate)
			delete(rawMsg, key)
		case "sourceDatabaseId":
			err = unpopulate(val, "SourceDatabaseID", &d.SourceDatabaseID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &d.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseVulnerabilityAssessmentRuleBaselineItem.
func (d DatabaseVulnerabilityAssessmentRuleBaselineItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "result", d.Result)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseVulnerabilityAssessmentRuleBaselineProperties.
func (d DatabaseVulnerabilityAssessmentRuleBaselineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baselineResults", d.BaselineResults)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeletedServerProperties.
func (d DeletedServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "deletionTime", d.DeletionTime)
	populate(objectMap, "fullyQualifiedDomainName", d.FullyQualifiedDomainName)
	populate(objectMap, "originalId", d.OriginalID)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedServerProperties.
func (d *DeletedServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletionTime":
			err = unpopulateTimeRFC3339(val, "DeletionTime", &d.DeletionTime)
			delete(rawMsg, key)
		case "fullyQualifiedDomainName":
			err = unpopulate(val, "FullyQualifiedDomainName", &d.FullyQualifiedDomainName)
			delete(rawMsg, key)
		case "originalId":
			err = unpopulate(val, "OriginalID", &d.OriginalID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DistributedAvailabilityGroup.
func (d DistributedAvailabilityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ElasticPool.
func (e ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", e.ID)
	populate(objectMap, "kind", e.Kind)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "sku", e.SKU)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ElasticPoolActivityProperties.
func (e ElasticPoolActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "elasticPoolName", e.ElasticPoolName)
	populateTimeRFC3339(objectMap, "endTime", e.EndTime)
	populate(objectMap, "errorCode", e.ErrorCode)
	populate(objectMap, "errorMessage", e.ErrorMessage)
	populate(objectMap, "errorSeverity", e.ErrorSeverity)
	populate(objectMap, "operation", e.Operation)
	populate(objectMap, "operationId", e.OperationID)
	populate(objectMap, "percentComplete", e.PercentComplete)
	populate(objectMap, "requestedDatabaseDtuCap", e.RequestedDatabaseDtuCap)
	populate(objectMap, "requestedDatabaseDtuGuarantee", e.RequestedDatabaseDtuGuarantee)
	populate(objectMap, "requestedDatabaseDtuMax", e.RequestedDatabaseDtuMax)
	populate(objectMap, "requestedDatabaseDtuMin", e.RequestedDatabaseDtuMin)
	populate(objectMap, "requestedDtu", e.RequestedDtu)
	populate(objectMap, "requestedDtuGuarantee", e.RequestedDtuGuarantee)
	populate(objectMap, "requestedElasticPoolName", e.RequestedElasticPoolName)
	populate(objectMap, "requestedStorageLimitInGB", e.RequestedStorageLimitInGB)
	populate(objectMap, "requestedStorageLimitInMB", e.RequestedStorageLimitInMB)
	populate(objectMap, "serverName", e.ServerName)
	populateTimeRFC3339(objectMap, "startTime", e.StartTime)
	populate(objectMap, "state", e.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticPoolActivityProperties.
func (e *ElasticPoolActivityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &e.ElasticPoolName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &e.EndTime)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &e.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &e.ErrorMessage)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &e.ErrorSeverity)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &e.Operation)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &e.OperationID)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &e.PercentComplete)
			delete(rawMsg, key)
		case "requestedDatabaseDtuCap":
			err = unpopulate(val, "RequestedDatabaseDtuCap", &e.RequestedDatabaseDtuCap)
			delete(rawMsg, key)
		case "requestedDatabaseDtuGuarantee":
			err = unpopulate(val, "RequestedDatabaseDtuGuarantee", &e.RequestedDatabaseDtuGuarantee)
			delete(rawMsg, key)
		case "requestedDatabaseDtuMax":
			err = unpopulate(val, "RequestedDatabaseDtuMax", &e.RequestedDatabaseDtuMax)
			delete(rawMsg, key)
		case "requestedDatabaseDtuMin":
			err = unpopulate(val, "RequestedDatabaseDtuMin", &e.RequestedDatabaseDtuMin)
			delete(rawMsg, key)
		case "requestedDtu":
			err = unpopulate(val, "RequestedDtu", &e.RequestedDtu)
			delete(rawMsg, key)
		case "requestedDtuGuarantee":
			err = unpopulate(val, "RequestedDtuGuarantee", &e.RequestedDtuGuarantee)
			delete(rawMsg, key)
		case "requestedElasticPoolName":
			err = unpopulate(val, "RequestedElasticPoolName", &e.RequestedElasticPoolName)
			delete(rawMsg, key)
		case "requestedStorageLimitInGB":
			err = unpopulate(val, "RequestedStorageLimitInGB", &e.RequestedStorageLimitInGB)
			delete(rawMsg, key)
		case "requestedStorageLimitInMB":
			err = unpopulate(val, "RequestedStorageLimitInMB", &e.RequestedStorageLimitInMB)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &e.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &e.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticPoolDatabaseActivityProperties.
func (e ElasticPoolDatabaseActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentElasticPoolName", e.CurrentElasticPoolName)
	populate(objectMap, "currentServiceObjective", e.CurrentServiceObjective)
	populate(objectMap, "databaseName", e.DatabaseName)
	populateTimeRFC3339(objectMap, "endTime", e.EndTime)
	populate(objectMap, "errorCode", e.ErrorCode)
	populate(objectMap, "errorMessage", e.ErrorMessage)
	populate(objectMap, "errorSeverity", e.ErrorSeverity)
	populate(objectMap, "operation", e.Operation)
	populate(objectMap, "operationId", e.OperationID)
	populate(objectMap, "percentComplete", e.PercentComplete)
	populate(objectMap, "requestedElasticPoolName", e.RequestedElasticPoolName)
	populate(objectMap, "requestedServiceObjective", e.RequestedServiceObjective)
	populate(objectMap, "serverName", e.ServerName)
	populateTimeRFC3339(objectMap, "startTime", e.StartTime)
	populate(objectMap, "state", e.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticPoolDatabaseActivityProperties.
func (e *ElasticPoolDatabaseActivityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentElasticPoolName":
			err = unpopulate(val, "CurrentElasticPoolName", &e.CurrentElasticPoolName)
			delete(rawMsg, key)
		case "currentServiceObjective":
			err = unpopulate(val, "CurrentServiceObjective", &e.CurrentServiceObjective)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &e.DatabaseName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &e.EndTime)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &e.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &e.ErrorMessage)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &e.ErrorSeverity)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &e.Operation)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &e.OperationID)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &e.PercentComplete)
			delete(rawMsg, key)
		case "requestedElasticPoolName":
			err = unpopulate(val, "RequestedElasticPoolName", &e.RequestedElasticPoolName)
			delete(rawMsg, key)
		case "requestedServiceObjective":
			err = unpopulate(val, "RequestedServiceObjective", &e.RequestedServiceObjective)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &e.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &e.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticPoolOperationProperties.
func (e ElasticPoolOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", e.Description)
	populate(objectMap, "elasticPoolName", e.ElasticPoolName)
	populate(objectMap, "errorCode", e.ErrorCode)
	populate(objectMap, "errorDescription", e.ErrorDescription)
	populate(objectMap, "errorSeverity", e.ErrorSeverity)
	populateTimeRFC3339(objectMap, "estimatedCompletionTime", e.EstimatedCompletionTime)
	populate(objectMap, "isCancellable", e.IsCancellable)
	populate(objectMap, "isUserError", e.IsUserError)
	populate(objectMap, "operation", e.Operation)
	populate(objectMap, "operationFriendlyName", e.OperationFriendlyName)
	populate(objectMap, "percentComplete", e.PercentComplete)
	populate(objectMap, "serverName", e.ServerName)
	populateTimeRFC3339(objectMap, "startTime", e.StartTime)
	populate(objectMap, "state", e.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticPoolOperationProperties.
func (e *ElasticPoolOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &e.ElasticPoolName)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &e.ErrorCode)
			delete(rawMsg, key)
		case "errorDescription":
			err = unpopulate(val, "ErrorDescription", &e.ErrorDescription)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &e.ErrorSeverity)
			delete(rawMsg, key)
		case "estimatedCompletionTime":
			err = unpopulateTimeRFC3339(val, "EstimatedCompletionTime", &e.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &e.IsCancellable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &e.IsUserError)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &e.Operation)
			delete(rawMsg, key)
		case "operationFriendlyName":
			err = unpopulate(val, "OperationFriendlyName", &e.OperationFriendlyName)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &e.PercentComplete)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &e.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &e.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticPoolProperties.
func (e ElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationDate", e.CreationDate)
	populate(objectMap, "highAvailabilityReplicaCount", e.HighAvailabilityReplicaCount)
	populate(objectMap, "licenseType", e.LicenseType)
	populate(objectMap, "maintenanceConfigurationId", e.MaintenanceConfigurationID)
	populate(objectMap, "maxSizeBytes", e.MaxSizeBytes)
	populate(objectMap, "perDatabaseSettings", e.PerDatabaseSettings)
	populate(objectMap, "state", e.State)
	populate(objectMap, "zoneRedundant", e.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticPoolProperties.
func (e *ElasticPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &e.CreationDate)
			delete(rawMsg, key)
		case "highAvailabilityReplicaCount":
			err = unpopulate(val, "HighAvailabilityReplicaCount", &e.HighAvailabilityReplicaCount)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &e.LicenseType)
			delete(rawMsg, key)
		case "maintenanceConfigurationId":
			err = unpopulate(val, "MaintenanceConfigurationID", &e.MaintenanceConfigurationID)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &e.MaxSizeBytes)
			delete(rawMsg, key)
		case "perDatabaseSettings":
			err = unpopulate(val, "PerDatabaseSettings", &e.PerDatabaseSettings)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &e.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticPoolUpdate.
func (e ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "sku", e.SKU)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedDatabaseBlobAuditingPolicyProperties.
func (e ExtendedDatabaseBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", e.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", e.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isManagedIdentityInUse", e.IsManagedIdentityInUse)
	populate(objectMap, "isStorageSecondaryKeyInUse", e.IsStorageSecondaryKeyInUse)
	populate(objectMap, "predicateExpression", e.PredicateExpression)
	populate(objectMap, "queueDelayMs", e.QueueDelayMs)
	populate(objectMap, "retentionDays", e.RetentionDays)
	populate(objectMap, "state", e.State)
	populate(objectMap, "storageAccountAccessKey", e.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", e.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", e.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedServerBlobAuditingPolicyProperties.
func (e ExtendedServerBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", e.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", e.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isDevopsAuditEnabled", e.IsDevopsAuditEnabled)
	populate(objectMap, "isManagedIdentityInUse", e.IsManagedIdentityInUse)
	populate(objectMap, "isStorageSecondaryKeyInUse", e.IsStorageSecondaryKeyInUse)
	populate(objectMap, "predicateExpression", e.PredicateExpression)
	populate(objectMap, "queueDelayMs", e.QueueDelayMs)
	populate(objectMap, "retentionDays", e.RetentionDays)
	populate(objectMap, "state", e.State)
	populate(objectMap, "storageAccountAccessKey", e.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", e.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", e.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FailoverGroup.
func (f FailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FailoverGroupProperties.
func (f FailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", f.Databases)
	populate(objectMap, "partnerServers", f.PartnerServers)
	populate(objectMap, "readOnlyEndpoint", f.ReadOnlyEndpoint)
	populate(objectMap, "readWriteEndpoint", f.ReadWriteEndpoint)
	populate(objectMap, "replicationRole", f.ReplicationRole)
	populate(objectMap, "replicationState", f.ReplicationState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FailoverGroupUpdate.
func (f FailoverGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FailoverGroupUpdateProperties.
func (f FailoverGroupUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databases", f.Databases)
	populate(objectMap, "readOnlyEndpoint", f.ReadOnlyEndpoint)
	populate(objectMap, "readWriteEndpoint", f.ReadWriteEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FirewallRuleList.
func (f FirewallRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "values", f.Values)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ImportExportOperationResultProperties.
func (i ImportExportOperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "databaseName", i.DatabaseName)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "lastModifiedTime", i.LastModifiedTime)
	populate(objectMap, "privateEndpointConnections", i.PrivateEndpointConnections)
	populate(objectMap, "queuedTime", i.QueuedTime)
	populate(objectMap, "requestId", i.RequestID)
	populate(objectMap, "requestType", i.RequestType)
	populate(objectMap, "serverName", i.ServerName)
	populate(objectMap, "status", i.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstanceFailoverGroupProperties.
func (i InstanceFailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedInstancePairs", i.ManagedInstancePairs)
	populate(objectMap, "partnerRegions", i.PartnerRegions)
	populate(objectMap, "readOnlyEndpoint", i.ReadOnlyEndpoint)
	populate(objectMap, "readWriteEndpoint", i.ReadWriteEndpoint)
	populate(objectMap, "replicationRole", i.ReplicationRole)
	populate(objectMap, "replicationState", i.ReplicationState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstancePool.
func (i InstancePool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstancePoolUpdate.
func (i InstancePoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobAgent.
func (j JobAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "sku", j.SKU)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobAgentUpdate.
func (j JobAgentUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", j.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobExecutionProperties.
func (j JobExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createTime", j.CreateTime)
	populateTimeRFC3339(objectMap, "currentAttemptStartTime", j.CurrentAttemptStartTime)
	populate(objectMap, "currentAttempts", j.CurrentAttempts)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "jobExecutionId", j.JobExecutionID)
	populate(objectMap, "jobVersion", j.JobVersion)
	populate(objectMap, "lastMessage", j.LastMessage)
	populate(objectMap, "lifecycle", j.Lifecycle)
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "stepId", j.StepID)
	populate(objectMap, "stepName", j.StepName)
	populate(objectMap, "target", j.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExecutionProperties.
func (j *JobExecutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateTimeRFC3339(val, "CreateTime", &j.CreateTime)
			delete(rawMsg, key)
		case "currentAttemptStartTime":
			err = unpopulateTimeRFC3339(val, "CurrentAttemptStartTime", &j.CurrentAttemptStartTime)
			delete(rawMsg, key)
		case "currentAttempts":
			err = unpopulate(val, "CurrentAttempts", &j.CurrentAttempts)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "jobExecutionId":
			err = unpopulate(val, "JobExecutionID", &j.JobExecutionID)
			delete(rawMsg, key)
		case "jobVersion":
			err = unpopulate(val, "JobVersion", &j.JobVersion)
			delete(rawMsg, key)
		case "lastMessage":
			err = unpopulate(val, "LastMessage", &j.LastMessage)
			delete(rawMsg, key)
		case "lifecycle":
			err = unpopulate(val, "Lifecycle", &j.Lifecycle)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &j.ProvisioningState)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "stepId":
			err = unpopulate(val, "StepID", &j.StepID)
			delete(rawMsg, key)
		case "stepName":
			err = unpopulate(val, "StepName", &j.StepName)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &j.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobSchedule.
func (j JobSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enabled", j.Enabled)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "interval", j.Interval)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobSchedule.
func (j *JobSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &j.Enabled)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &j.Interval)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobTargetGroupProperties.
func (j JobTargetGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "members", j.Members)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LongTermRetentionBackupProperties.
func (l LongTermRetentionBackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "backupExpirationTime", l.BackupExpirationTime)
	populate(objectMap, "backupStorageRedundancy", l.BackupStorageRedundancy)
	populateTimeRFC3339(objectMap, "backupTime", l.BackupTime)
	populateTimeRFC3339(objectMap, "databaseDeletionTime", l.DatabaseDeletionTime)
	populate(objectMap, "databaseName", l.DatabaseName)
	populate(objectMap, "requestedBackupStorageRedundancy", l.RequestedBackupStorageRedundancy)
	populateTimeRFC3339(objectMap, "serverCreateTime", l.ServerCreateTime)
	populate(objectMap, "serverName", l.ServerName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LongTermRetentionBackupProperties.
func (l *LongTermRetentionBackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupExpirationTime":
			err = unpopulateTimeRFC3339(val, "BackupExpirationTime", &l.BackupExpirationTime)
			delete(rawMsg, key)
		case "backupStorageRedundancy":
			err = unpopulate(val, "BackupStorageRedundancy", &l.BackupStorageRedundancy)
			delete(rawMsg, key)
		case "backupTime":
			err = unpopulateTimeRFC3339(val, "BackupTime", &l.BackupTime)
			delete(rawMsg, key)
		case "databaseDeletionTime":
			err = unpopulateTimeRFC3339(val, "DatabaseDeletionTime", &l.DatabaseDeletionTime)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &l.DatabaseName)
			delete(rawMsg, key)
		case "requestedBackupStorageRedundancy":
			err = unpopulate(val, "RequestedBackupStorageRedundancy", &l.RequestedBackupStorageRedundancy)
			delete(rawMsg, key)
		case "serverCreateTime":
			err = unpopulateTimeRFC3339(val, "ServerCreateTime", &l.ServerCreateTime)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &l.ServerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowOptionsProperties.
func (m MaintenanceWindowOptionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowMultipleMaintenanceWindowsPerCycle", m.AllowMultipleMaintenanceWindowsPerCycle)
	populate(objectMap, "defaultDurationInMinutes", m.DefaultDurationInMinutes)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "maintenanceWindowCycles", m.MaintenanceWindowCycles)
	populate(objectMap, "minCycles", m.MinCycles)
	populate(objectMap, "minDurationInMinutes", m.MinDurationInMinutes)
	populate(objectMap, "timeGranularityInMinutes", m.TimeGranularityInMinutes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowsProperties.
func (m MaintenanceWindowsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "timeRanges", m.TimeRanges)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedBackupShortTermRetentionPolicy.
func (m ManagedBackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDatabase.
func (m ManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDatabaseProperties.
func (m ManagedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoCompleteRestore", m.AutoCompleteRestore)
	populate(objectMap, "catalogCollation", m.CatalogCollation)
	populate(objectMap, "collation", m.Collation)
	populate(objectMap, "createMode", m.CreateMode)
	populateTimeRFC3339(objectMap, "creationDate", m.CreationDate)
	populate(objectMap, "defaultSecondaryLocation", m.DefaultSecondaryLocation)
	populateTimeRFC3339(objectMap, "earliestRestorePoint", m.EarliestRestorePoint)
	populate(objectMap, "failoverGroupId", m.FailoverGroupID)
	populate(objectMap, "lastBackupName", m.LastBackupName)
	populate(objectMap, "longTermRetentionBackupResourceId", m.LongTermRetentionBackupResourceID)
	populate(objectMap, "recoverableDatabaseId", m.RecoverableDatabaseID)
	populate(objectMap, "restorableDroppedDatabaseId", m.RestorableDroppedDatabaseID)
	populateTimeRFC3339(objectMap, "restorePointInTime", m.RestorePointInTime)
	populate(objectMap, "sourceDatabaseId", m.SourceDatabaseID)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "storageContainerSasToken", m.StorageContainerSasToken)
	populate(objectMap, "storageContainerUri", m.StorageContainerURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedDatabaseProperties.
func (m *ManagedDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoCompleteRestore":
			err = unpopulate(val, "AutoCompleteRestore", &m.AutoCompleteRestore)
			delete(rawMsg, key)
		case "catalogCollation":
			err = unpopulate(val, "CatalogCollation", &m.CatalogCollation)
			delete(rawMsg, key)
		case "collation":
			err = unpopulate(val, "Collation", &m.Collation)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &m.CreateMode)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &m.CreationDate)
			delete(rawMsg, key)
		case "defaultSecondaryLocation":
			err = unpopulate(val, "DefaultSecondaryLocation", &m.DefaultSecondaryLocation)
			delete(rawMsg, key)
		case "earliestRestorePoint":
			err = unpopulateTimeRFC3339(val, "EarliestRestorePoint", &m.EarliestRestorePoint)
			delete(rawMsg, key)
		case "failoverGroupId":
			err = unpopulate(val, "FailoverGroupID", &m.FailoverGroupID)
			delete(rawMsg, key)
		case "lastBackupName":
			err = unpopulate(val, "LastBackupName", &m.LastBackupName)
			delete(rawMsg, key)
		case "longTermRetentionBackupResourceId":
			err = unpopulate(val, "LongTermRetentionBackupResourceID", &m.LongTermRetentionBackupResourceID)
			delete(rawMsg, key)
		case "recoverableDatabaseId":
			err = unpopulate(val, "RecoverableDatabaseID", &m.RecoverableDatabaseID)
			delete(rawMsg, key)
		case "restorableDroppedDatabaseId":
			err = unpopulate(val, "RestorableDroppedDatabaseID", &m.RestorableDroppedDatabaseID)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &m.RestorePointInTime)
			delete(rawMsg, key)
		case "sourceDatabaseId":
			err = unpopulate(val, "SourceDatabaseID", &m.SourceDatabaseID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "storageContainerSasToken":
			err = unpopulate(val, "StorageContainerSasToken", &m.StorageContainerSasToken)
			delete(rawMsg, key)
		case "storageContainerUri":
			err = unpopulate(val, "StorageContainerURI", &m.StorageContainerURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDatabaseRestoreDetailsProperties.
func (m ManagedDatabaseRestoreDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blockReason", m.BlockReason)
	populate(objectMap, "currentRestoringFileName", m.CurrentRestoringFileName)
	populate(objectMap, "lastRestoredFileName", m.LastRestoredFileName)
	populateTimeRFC3339(objectMap, "lastRestoredFileTime", m.LastRestoredFileTime)
	populate(objectMap, "lastUploadedFileName", m.LastUploadedFileName)
	populateTimeRFC3339(objectMap, "lastUploadedFileTime", m.LastUploadedFileTime)
	populate(objectMap, "numberOfFilesDetected", m.NumberOfFilesDetected)
	populate(objectMap, "percentCompleted", m.PercentCompleted)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "unrestorableFiles", m.UnrestorableFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedDatabaseRestoreDetailsProperties.
func (m *ManagedDatabaseRestoreDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blockReason":
			err = unpopulate(val, "BlockReason", &m.BlockReason)
			delete(rawMsg, key)
		case "currentRestoringFileName":
			err = unpopulate(val, "CurrentRestoringFileName", &m.CurrentRestoringFileName)
			delete(rawMsg, key)
		case "lastRestoredFileName":
			err = unpopulate(val, "LastRestoredFileName", &m.LastRestoredFileName)
			delete(rawMsg, key)
		case "lastRestoredFileTime":
			err = unpopulateTimeRFC3339(val, "LastRestoredFileTime", &m.LastRestoredFileTime)
			delete(rawMsg, key)
		case "lastUploadedFileName":
			err = unpopulate(val, "LastUploadedFileName", &m.LastUploadedFileName)
			delete(rawMsg, key)
		case "lastUploadedFileTime":
			err = unpopulateTimeRFC3339(val, "LastUploadedFileTime", &m.LastUploadedFileTime)
			delete(rawMsg, key)
		case "numberOfFilesDetected":
			err = unpopulate(val, "NumberOfFilesDetected", &m.NumberOfFilesDetected)
			delete(rawMsg, key)
		case "percentCompleted":
			err = unpopulate(val, "PercentCompleted", &m.PercentCompleted)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "unrestorableFiles":
			err = unpopulate(val, "UnrestorableFiles", &m.UnrestorableFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDatabaseUpdate.
func (m ManagedDatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstance.
func (m ManagedInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstanceKeyProperties.
func (m ManagedInstanceKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoRotationEnabled", m.AutoRotationEnabled)
	populateTimeRFC3339(objectMap, "creationDate", m.CreationDate)
	populate(objectMap, "serverKeyType", m.ServerKeyType)
	populate(objectMap, "thumbprint", m.Thumbprint)
	populate(objectMap, "uri", m.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedInstanceKeyProperties.
func (m *ManagedInstanceKeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoRotationEnabled":
			err = unpopulate(val, "AutoRotationEnabled", &m.AutoRotationEnabled)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &m.CreationDate)
			delete(rawMsg, key)
		case "serverKeyType":
			err = unpopulate(val, "ServerKeyType", &m.ServerKeyType)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &m.Thumbprint)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &m.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstanceLongTermRetentionBackupProperties.
func (m ManagedInstanceLongTermRetentionBackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "backupExpirationTime", m.BackupExpirationTime)
	populate(objectMap, "backupStorageRedundancy", m.BackupStorageRedundancy)
	populateTimeRFC3339(objectMap, "backupTime", m.BackupTime)
	populateTimeRFC3339(objectMap, "databaseDeletionTime", m.DatabaseDeletionTime)
	populate(objectMap, "databaseName", m.DatabaseName)
	populateTimeRFC3339(objectMap, "managedInstanceCreateTime", m.ManagedInstanceCreateTime)
	populate(objectMap, "managedInstanceName", m.ManagedInstanceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedInstanceLongTermRetentionBackupProperties.
func (m *ManagedInstanceLongTermRetentionBackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupExpirationTime":
			err = unpopulateTimeRFC3339(val, "BackupExpirationTime", &m.BackupExpirationTime)
			delete(rawMsg, key)
		case "backupStorageRedundancy":
			err = unpopulate(val, "BackupStorageRedundancy", &m.BackupStorageRedundancy)
			delete(rawMsg, key)
		case "backupTime":
			err = unpopulateTimeRFC3339(val, "BackupTime", &m.BackupTime)
			delete(rawMsg, key)
		case "databaseDeletionTime":
			err = unpopulateTimeRFC3339(val, "DatabaseDeletionTime", &m.DatabaseDeletionTime)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &m.DatabaseName)
			delete(rawMsg, key)
		case "managedInstanceCreateTime":
			err = unpopulateTimeRFC3339(val, "ManagedInstanceCreateTime", &m.ManagedInstanceCreateTime)
			delete(rawMsg, key)
		case "managedInstanceName":
			err = unpopulate(val, "ManagedInstanceName", &m.ManagedInstanceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstanceOperationProperties.
func (m ManagedInstanceOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", m.Description)
	populate(objectMap, "errorCode", m.ErrorCode)
	populate(objectMap, "errorDescription", m.ErrorDescription)
	populate(objectMap, "errorSeverity", m.ErrorSeverity)
	populateTimeRFC3339(objectMap, "estimatedCompletionTime", m.EstimatedCompletionTime)
	populate(objectMap, "isCancellable", m.IsCancellable)
	populate(objectMap, "isUserError", m.IsUserError)
	populate(objectMap, "managedInstanceName", m.ManagedInstanceName)
	populate(objectMap, "operation", m.Operation)
	populate(objectMap, "operationFriendlyName", m.OperationFriendlyName)
	populate(objectMap, "operationParameters", m.OperationParameters)
	populate(objectMap, "operationSteps", m.OperationSteps)
	populate(objectMap, "percentComplete", m.PercentComplete)
	populateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedInstanceOperationProperties.
func (m *ManagedInstanceOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &m.ErrorCode)
			delete(rawMsg, key)
		case "errorDescription":
			err = unpopulate(val, "ErrorDescription", &m.ErrorDescription)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &m.ErrorSeverity)
			delete(rawMsg, key)
		case "estimatedCompletionTime":
			err = unpopulateTimeRFC3339(val, "EstimatedCompletionTime", &m.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &m.IsCancellable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &m.IsUserError)
			delete(rawMsg, key)
		case "managedInstanceName":
			err = unpopulate(val, "ManagedInstanceName", &m.ManagedInstanceName)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &m.Operation)
			delete(rawMsg, key)
		case "operationFriendlyName":
			err = unpopulate(val, "OperationFriendlyName", &m.OperationFriendlyName)
			delete(rawMsg, key)
		case "operationParameters":
			err = unpopulate(val, "OperationParameters", &m.OperationParameters)
			delete(rawMsg, key)
		case "operationSteps":
			err = unpopulate(val, "OperationSteps", &m.OperationSteps)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &m.PercentComplete)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstanceOperationSteps.
func (m ManagedInstanceOperationSteps) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentStep", m.CurrentStep)
	populate(objectMap, "stepsList", m.StepsList)
	populate(objectMap, "totalSteps", m.TotalSteps)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstancePrivateLinkProperties.
func (m ManagedInstancePrivateLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", m.GroupID)
	populate(objectMap, "requiredMembers", m.RequiredMembers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstanceProperties.
func (m ManagedInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLogin", m.AdministratorLogin)
	populate(objectMap, "administratorLoginPassword", m.AdministratorLoginPassword)
	populate(objectMap, "administrators", m.Administrators)
	populate(objectMap, "collation", m.Collation)
	populate(objectMap, "currentBackupStorageRedundancy", m.CurrentBackupStorageRedundancy)
	populate(objectMap, "dnsZone", m.DNSZone)
	populate(objectMap, "dnsZonePartner", m.DNSZonePartner)
	populate(objectMap, "fullyQualifiedDomainName", m.FullyQualifiedDomainName)
	populate(objectMap, "instancePoolId", m.InstancePoolID)
	populate(objectMap, "keyId", m.KeyID)
	populate(objectMap, "licenseType", m.LicenseType)
	populate(objectMap, "maintenanceConfigurationId", m.MaintenanceConfigurationID)
	populate(objectMap, "managedInstanceCreateMode", m.ManagedInstanceCreateMode)
	populate(objectMap, "minimalTlsVersion", m.MinimalTLSVersion)
	populate(objectMap, "primaryUserAssignedIdentityId", m.PrimaryUserAssignedIdentityID)
	populate(objectMap, "privateEndpointConnections", m.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "proxyOverride", m.ProxyOverride)
	populate(objectMap, "publicDataEndpointEnabled", m.PublicDataEndpointEnabled)
	populate(objectMap, "requestedBackupStorageRedundancy", m.RequestedBackupStorageRedundancy)
	populateTimeRFC3339(objectMap, "restorePointInTime", m.RestorePointInTime)
	populate(objectMap, "servicePrincipal", m.ServicePrincipal)
	populate(objectMap, "sourceManagedInstanceId", m.SourceManagedInstanceID)
	populate(objectMap, "state", m.State)
	populate(objectMap, "storageSizeInGB", m.StorageSizeInGB)
	populate(objectMap, "subnetId", m.SubnetID)
	populate(objectMap, "timezoneId", m.TimezoneID)
	populate(objectMap, "vCores", m.VCores)
	populate(objectMap, "zoneRedundant", m.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedInstanceProperties.
func (m *ManagedInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLogin":
			err = unpopulate(val, "AdministratorLogin", &m.AdministratorLogin)
			delete(rawMsg, key)
		case "administratorLoginPassword":
			err = unpopulate(val, "AdministratorLoginPassword", &m.AdministratorLoginPassword)
			delete(rawMsg, key)
		case "administrators":
			err = unpopulate(val, "Administrators", &m.Administrators)
			delete(rawMsg, key)
		case "collation":
			err = unpopulate(val, "Collation", &m.Collation)
			delete(rawMsg, key)
		case "currentBackupStorageRedundancy":
			err = unpopulate(val, "CurrentBackupStorageRedundancy", &m.CurrentBackupStorageRedundancy)
			delete(rawMsg, key)
		case "dnsZone":
			err = unpopulate(val, "DNSZone", &m.DNSZone)
			delete(rawMsg, key)
		case "dnsZonePartner":
			err = unpopulate(val, "DNSZonePartner", &m.DNSZonePartner)
			delete(rawMsg, key)
		case "fullyQualifiedDomainName":
			err = unpopulate(val, "FullyQualifiedDomainName", &m.FullyQualifiedDomainName)
			delete(rawMsg, key)
		case "instancePoolId":
			err = unpopulate(val, "InstancePoolID", &m.InstancePoolID)
			delete(rawMsg, key)
		case "keyId":
			err = unpopulate(val, "KeyID", &m.KeyID)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &m.LicenseType)
			delete(rawMsg, key)
		case "maintenanceConfigurationId":
			err = unpopulate(val, "MaintenanceConfigurationID", &m.MaintenanceConfigurationID)
			delete(rawMsg, key)
		case "managedInstanceCreateMode":
			err = unpopulate(val, "ManagedInstanceCreateMode", &m.ManagedInstanceCreateMode)
			delete(rawMsg, key)
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &m.MinimalTLSVersion)
			delete(rawMsg, key)
		case "primaryUserAssignedIdentityId":
			err = unpopulate(val, "PrimaryUserAssignedIdentityID", &m.PrimaryUserAssignedIdentityID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &m.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "proxyOverride":
			err = unpopulate(val, "ProxyOverride", &m.ProxyOverride)
			delete(rawMsg, key)
		case "publicDataEndpointEnabled":
			err = unpopulate(val, "PublicDataEndpointEnabled", &m.PublicDataEndpointEnabled)
			delete(rawMsg, key)
		case "requestedBackupStorageRedundancy":
			err = unpopulate(val, "RequestedBackupStorageRedundancy", &m.RequestedBackupStorageRedundancy)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &m.RestorePointInTime)
			delete(rawMsg, key)
		case "servicePrincipal":
			err = unpopulate(val, "ServicePrincipal", &m.ServicePrincipal)
			delete(rawMsg, key)
		case "sourceManagedInstanceId":
			err = unpopulate(val, "SourceManagedInstanceID", &m.SourceManagedInstanceID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "storageSizeInGB":
			err = unpopulate(val, "StorageSizeInGB", &m.StorageSizeInGB)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &m.SubnetID)
			delete(rawMsg, key)
		case "timezoneId":
			err = unpopulate(val, "TimezoneID", &m.TimezoneID)
			delete(rawMsg, key)
		case "vCores":
			err = unpopulate(val, "VCores", &m.VCores)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &m.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedInstanceUpdate.
func (m ManagedInstanceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Metric.
func (m *Metric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "metricValues":
			err = unpopulate(val, "MetricValues", &m.MetricValues)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricValue.
func (m *MetricValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "average":
			err = unpopulate(val, "Average", &m.Average)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &m.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &m.Minimum)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &m.Timestamp)
			delete(rawMsg, key)
		case "total":
			err = unpopulate(val, "Total", &m.Total)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryMetricInterval.
func (q QueryMetricInterval) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "executionCount", q.ExecutionCount)
	populate(objectMap, "intervalStartTime", q.IntervalStartTime)
	populate(objectMap, "intervalType", q.IntervalType)
	populate(objectMap, "metrics", q.Metrics)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryStatisticsProperties.
func (q QueryStatisticsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", q.DatabaseName)
	populate(objectMap, "endTime", q.EndTime)
	populate(objectMap, "intervals", q.Intervals)
	populate(objectMap, "queryId", q.QueryID)
	populate(objectMap, "startTime", q.StartTime)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedAction.
func (r RecommendedAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedActionMetricInfo.
func (r RecommendedActionMetricInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "metricName", r.MetricName)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	populate(objectMap, "timeGrain", r.TimeGrain)
	populate(objectMap, "unit", r.Unit)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedActionMetricInfo.
func (r *RecommendedActionMetricInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricName":
			err = unpopulate(val, "MetricName", &r.MetricName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &r.TimeGrain)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedActionProperties.
func (r RecommendedActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "details", r.Details)
	populate(objectMap, "errorDetails", r.ErrorDetails)
	populate(objectMap, "estimatedImpact", r.EstimatedImpact)
	populate(objectMap, "executeActionDuration", r.ExecuteActionDuration)
	populate(objectMap, "executeActionInitiatedBy", r.ExecuteActionInitiatedBy)
	populateTimeRFC3339(objectMap, "executeActionInitiatedTime", r.ExecuteActionInitiatedTime)
	populateTimeRFC3339(objectMap, "executeActionStartTime", r.ExecuteActionStartTime)
	populate(objectMap, "implementationDetails", r.ImplementationDetails)
	populate(objectMap, "isArchivedAction", r.IsArchivedAction)
	populate(objectMap, "isExecutableAction", r.IsExecutableAction)
	populate(objectMap, "isRevertableAction", r.IsRevertableAction)
	populateTimeRFC3339(objectMap, "lastRefresh", r.LastRefresh)
	populate(objectMap, "linkedObjects", r.LinkedObjects)
	populate(objectMap, "observedImpact", r.ObservedImpact)
	populate(objectMap, "recommendationReason", r.RecommendationReason)
	populate(objectMap, "revertActionDuration", r.RevertActionDuration)
	populate(objectMap, "revertActionInitiatedBy", r.RevertActionInitiatedBy)
	populateTimeRFC3339(objectMap, "revertActionInitiatedTime", r.RevertActionInitiatedTime)
	populateTimeRFC3339(objectMap, "revertActionStartTime", r.RevertActionStartTime)
	populate(objectMap, "score", r.Score)
	populate(objectMap, "state", r.State)
	populate(objectMap, "timeSeries", r.TimeSeries)
	populateTimeRFC3339(objectMap, "validSince", r.ValidSince)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedActionProperties.
func (r *RecommendedActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &r.Details)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &r.ErrorDetails)
			delete(rawMsg, key)
		case "estimatedImpact":
			err = unpopulate(val, "EstimatedImpact", &r.EstimatedImpact)
			delete(rawMsg, key)
		case "executeActionDuration":
			err = unpopulate(val, "ExecuteActionDuration", &r.ExecuteActionDuration)
			delete(rawMsg, key)
		case "executeActionInitiatedBy":
			err = unpopulate(val, "ExecuteActionInitiatedBy", &r.ExecuteActionInitiatedBy)
			delete(rawMsg, key)
		case "executeActionInitiatedTime":
			err = unpopulateTimeRFC3339(val, "ExecuteActionInitiatedTime", &r.ExecuteActionInitiatedTime)
			delete(rawMsg, key)
		case "executeActionStartTime":
			err = unpopulateTimeRFC3339(val, "ExecuteActionStartTime", &r.ExecuteActionStartTime)
			delete(rawMsg, key)
		case "implementationDetails":
			err = unpopulate(val, "ImplementationDetails", &r.ImplementationDetails)
			delete(rawMsg, key)
		case "isArchivedAction":
			err = unpopulate(val, "IsArchivedAction", &r.IsArchivedAction)
			delete(rawMsg, key)
		case "isExecutableAction":
			err = unpopulate(val, "IsExecutableAction", &r.IsExecutableAction)
			delete(rawMsg, key)
		case "isRevertableAction":
			err = unpopulate(val, "IsRevertableAction", &r.IsRevertableAction)
			delete(rawMsg, key)
		case "lastRefresh":
			err = unpopulateTimeRFC3339(val, "LastRefresh", &r.LastRefresh)
			delete(rawMsg, key)
		case "linkedObjects":
			err = unpopulate(val, "LinkedObjects", &r.LinkedObjects)
			delete(rawMsg, key)
		case "observedImpact":
			err = unpopulate(val, "ObservedImpact", &r.ObservedImpact)
			delete(rawMsg, key)
		case "recommendationReason":
			err = unpopulate(val, "RecommendationReason", &r.RecommendationReason)
			delete(rawMsg, key)
		case "revertActionDuration":
			err = unpopulate(val, "RevertActionDuration", &r.RevertActionDuration)
			delete(rawMsg, key)
		case "revertActionInitiatedBy":
			err = unpopulate(val, "RevertActionInitiatedBy", &r.RevertActionInitiatedBy)
			delete(rawMsg, key)
		case "revertActionInitiatedTime":
			err = unpopulateTimeRFC3339(val, "RevertActionInitiatedTime", &r.RevertActionInitiatedTime)
			delete(rawMsg, key)
		case "revertActionStartTime":
			err = unpopulateTimeRFC3339(val, "RevertActionStartTime", &r.RevertActionStartTime)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &r.Score)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		case "timeSeries":
			err = unpopulate(val, "TimeSeries", &r.TimeSeries)
			delete(rawMsg, key)
		case "validSince":
			err = unpopulateTimeRFC3339(val, "ValidSince", &r.ValidSince)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedActionStateInfo.
func (r RecommendedActionStateInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionInitiatedBy", r.ActionInitiatedBy)
	populate(objectMap, "currentValue", r.CurrentValue)
	populateTimeRFC3339(objectMap, "lastModified", r.LastModified)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedActionStateInfo.
func (r *RecommendedActionStateInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionInitiatedBy":
			err = unpopulate(val, "ActionInitiatedBy", &r.ActionInitiatedBy)
			delete(rawMsg, key)
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &r.CurrentValue)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &r.LastModified)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedSensitivityLabelUpdateList.
func (r RecommendedSensitivityLabelUpdateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operations", r.Operations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecoverableDatabaseProperties.
func (r RecoverableDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "edition", r.Edition)
	populate(objectMap, "elasticPoolName", r.ElasticPoolName)
	populateTimeRFC3339(objectMap, "lastAvailableBackupDate", r.LastAvailableBackupDate)
	populate(objectMap, "serviceLevelObjective", r.ServiceLevelObjective)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoverableDatabaseProperties.
func (r *RecoverableDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "edition":
			err = unpopulate(val, "Edition", &r.Edition)
			delete(rawMsg, key)
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &r.ElasticPoolName)
			delete(rawMsg, key)
		case "lastAvailableBackupDate":
			err = unpopulateTimeRFC3339(val, "LastAvailableBackupDate", &r.LastAvailableBackupDate)
			delete(rawMsg, key)
		case "serviceLevelObjective":
			err = unpopulate(val, "ServiceLevelObjective", &r.ServiceLevelObjective)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationLinkProperties.
func (r ReplicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isTerminationAllowed", r.IsTerminationAllowed)
	populate(objectMap, "linkType", r.LinkType)
	populate(objectMap, "partnerDatabase", r.PartnerDatabase)
	populate(objectMap, "partnerLocation", r.PartnerLocation)
	populate(objectMap, "partnerRole", r.PartnerRole)
	populate(objectMap, "partnerServer", r.PartnerServer)
	populate(objectMap, "percentComplete", r.PercentComplete)
	populate(objectMap, "replicationMode", r.ReplicationMode)
	populate(objectMap, "replicationState", r.ReplicationState)
	populate(objectMap, "role", r.Role)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationLinkProperties.
func (r *ReplicationLinkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isTerminationAllowed":
			err = unpopulate(val, "IsTerminationAllowed", &r.IsTerminationAllowed)
			delete(rawMsg, key)
		case "linkType":
			err = unpopulate(val, "LinkType", &r.LinkType)
			delete(rawMsg, key)
		case "partnerDatabase":
			err = unpopulate(val, "PartnerDatabase", &r.PartnerDatabase)
			delete(rawMsg, key)
		case "partnerLocation":
			err = unpopulate(val, "PartnerLocation", &r.PartnerLocation)
			delete(rawMsg, key)
		case "partnerRole":
			err = unpopulate(val, "PartnerRole", &r.PartnerRole)
			delete(rawMsg, key)
		case "partnerServer":
			err = unpopulate(val, "PartnerServer", &r.PartnerServer)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &r.PercentComplete)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &r.ReplicationMode)
			delete(rawMsg, key)
		case "replicationState":
			err = unpopulate(val, "ReplicationState", &r.ReplicationState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &r.Role)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentity.
func (r ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "tenantId", r.TenantID)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "userAssignedIdentities", r.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedDatabase.
func (r RestorableDroppedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedDatabaseProperties.
func (r RestorableDroppedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupStorageRedundancy", r.BackupStorageRedundancy)
	populateTimeRFC3339(objectMap, "creationDate", r.CreationDate)
	populate(objectMap, "databaseName", r.DatabaseName)
	populateTimeRFC3339(objectMap, "deletionDate", r.DeletionDate)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	populate(objectMap, "maxSizeBytes", r.MaxSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableDroppedDatabaseProperties.
func (r *RestorableDroppedDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupStorageRedundancy":
			err = unpopulate(val, "BackupStorageRedundancy", &r.BackupStorageRedundancy)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &r.CreationDate)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &r.DatabaseName)
			delete(rawMsg, key)
		case "deletionDate":
			err = unpopulateTimeRFC3339(val, "DeletionDate", &r.DeletionDate)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &r.MaxSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedManagedDatabase.
func (r RestorableDroppedManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedManagedDatabaseProperties.
func (r RestorableDroppedManagedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationDate", r.CreationDate)
	populate(objectMap, "databaseName", r.DatabaseName)
	populateTimeRFC3339(objectMap, "deletionDate", r.DeletionDate)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableDroppedManagedDatabaseProperties.
func (r *RestorableDroppedManagedDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &r.CreationDate)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &r.DatabaseName)
			delete(rawMsg, key)
		case "deletionDate":
			err = unpopulateTimeRFC3339(val, "DeletionDate", &r.DeletionDate)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointProperties.
func (r RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	populateTimeRFC3339(objectMap, "restorePointCreationDate", r.RestorePointCreationDate)
	populate(objectMap, "restorePointLabel", r.RestorePointLabel)
	populate(objectMap, "restorePointType", r.RestorePointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointProperties.
func (r *RestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		case "restorePointCreationDate":
			err = unpopulateTimeRFC3339(val, "RestorePointCreationDate", &r.RestorePointCreationDate)
			delete(rawMsg, key)
		case "restorePointLabel":
			err = unpopulate(val, "RestorePointLabel", &r.RestorePointLabel)
			delete(rawMsg, key)
		case "restorePointType":
			err = unpopulate(val, "RestorePointType", &r.RestorePointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertPolicyProperties.
func (s SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlertPolicyProperties.
func (s *SecurityAlertPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "disabledAlerts":
			err = unpopulate(val, "DisabledAlerts", &s.DisabledAlerts)
			delete(rawMsg, key)
		case "emailAccountAdmins":
			err = unpopulate(val, "EmailAccountAdmins", &s.EmailAccountAdmins)
			delete(rawMsg, key)
		case "emailAddresses":
			err = unpopulate(val, "EmailAddresses", &s.EmailAddresses)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertsPolicyProperties.
func (s SecurityAlertsPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlertsPolicyProperties.
func (s *SecurityAlertsPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "disabledAlerts":
			err = unpopulate(val, "DisabledAlerts", &s.DisabledAlerts)
			delete(rawMsg, key)
		case "emailAccountAdmins":
			err = unpopulate(val, "EmailAccountAdmins", &s.EmailAccountAdmins)
			delete(rawMsg, key)
		case "emailAddresses":
			err = unpopulate(val, "EmailAddresses", &s.EmailAddresses)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityEventProperties.
func (s SecurityEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationName", s.ApplicationName)
	populate(objectMap, "clientIp", s.ClientIP)
	populate(objectMap, "database", s.Database)
	populateTimeRFC3339(objectMap, "eventTime", s.EventTime)
	populate(objectMap, "principalName", s.PrincipalName)
	populate(objectMap, "securityEventSqlInjectionAdditionalProperties", s.SecurityEventSQLInjectionAdditionalProperties)
	populate(objectMap, "securityEventType", s.SecurityEventType)
	populate(objectMap, "server", s.Server)
	populate(objectMap, "subscription", s.Subscription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityEventProperties.
func (s *SecurityEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &s.ApplicationName)
			delete(rawMsg, key)
		case "clientIp":
			err = unpopulate(val, "ClientIP", &s.ClientIP)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &s.Database)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateTimeRFC3339(val, "EventTime", &s.EventTime)
			delete(rawMsg, key)
		case "principalName":
			err = unpopulate(val, "PrincipalName", &s.PrincipalName)
			delete(rawMsg, key)
		case "securityEventSqlInjectionAdditionalProperties":
			err = unpopulate(val, "SecurityEventSQLInjectionAdditionalProperties", &s.SecurityEventSQLInjectionAdditionalProperties)
			delete(rawMsg, key)
		case "securityEventType":
			err = unpopulate(val, "SecurityEventType", &s.SecurityEventType)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &s.Server)
			delete(rawMsg, key)
		case "subscription":
			err = unpopulate(val, "Subscription", &s.Subscription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityEventsFilterParameters.
func (s *SecurityEventsFilterParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventTime":
			err = unpopulateTimeRFC3339(val, "EventTime", &s.EventTime)
			delete(rawMsg, key)
		case "showServerRecords":
			err = unpopulate(val, "ShowServerRecords", &s.ShowServerRecords)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelUpdateList.
func (s SensitivityLabelUpdateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operations", s.Operations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerAutomaticTuning.
func (s ServerAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerBlobAuditingPolicyProperties.
func (s ServerBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", s.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", s.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isDevopsAuditEnabled", s.IsDevopsAuditEnabled)
	populate(objectMap, "isManagedIdentityInUse", s.IsManagedIdentityInUse)
	populate(objectMap, "isStorageSecondaryKeyInUse", s.IsStorageSecondaryKeyInUse)
	populate(objectMap, "queueDelayMs", s.QueueDelayMs)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", s.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerKeyProperties.
func (s ServerKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoRotationEnabled", s.AutoRotationEnabled)
	populateTimeRFC3339(objectMap, "creationDate", s.CreationDate)
	populate(objectMap, "serverKeyType", s.ServerKeyType)
	populate(objectMap, "subregion", s.Subregion)
	populate(objectMap, "thumbprint", s.Thumbprint)
	populate(objectMap, "uri", s.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerKeyProperties.
func (s *ServerKeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoRotationEnabled":
			err = unpopulate(val, "AutoRotationEnabled", &s.AutoRotationEnabled)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &s.CreationDate)
			delete(rawMsg, key)
		case "serverKeyType":
			err = unpopulate(val, "ServerKeyType", &s.ServerKeyType)
			delete(rawMsg, key)
		case "subregion":
			err = unpopulate(val, "Subregion", &s.Subregion)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &s.Thumbprint)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &s.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerOperationProperties.
func (s ServerOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	populate(objectMap, "errorCode", s.ErrorCode)
	populate(objectMap, "errorDescription", s.ErrorDescription)
	populate(objectMap, "errorSeverity", s.ErrorSeverity)
	populateTimeRFC3339(objectMap, "estimatedCompletionTime", s.EstimatedCompletionTime)
	populate(objectMap, "isCancellable", s.IsCancellable)
	populate(objectMap, "isUserError", s.IsUserError)
	populate(objectMap, "operation", s.Operation)
	populate(objectMap, "operationFriendlyName", s.OperationFriendlyName)
	populate(objectMap, "percentComplete", s.PercentComplete)
	populate(objectMap, "serverName", s.ServerName)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerOperationProperties.
func (s *ServerOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		case "errorDescription":
			err = unpopulate(val, "ErrorDescription", &s.ErrorDescription)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &s.ErrorSeverity)
			delete(rawMsg, key)
		case "estimatedCompletionTime":
			err = unpopulateTimeRFC3339(val, "EstimatedCompletionTime", &s.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &s.IsCancellable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &s.IsUserError)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &s.Operation)
			delete(rawMsg, key)
		case "operationFriendlyName":
			err = unpopulate(val, "OperationFriendlyName", &s.OperationFriendlyName)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &s.PercentComplete)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &s.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerProperties.
func (s ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLogin", s.AdministratorLogin)
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	populate(objectMap, "administrators", s.Administrators)
	populate(objectMap, "federatedClientId", s.FederatedClientID)
	populate(objectMap, "fullyQualifiedDomainName", s.FullyQualifiedDomainName)
	populate(objectMap, "keyId", s.KeyID)
	populate(objectMap, "minimalTlsVersion", s.MinimalTLSVersion)
	populate(objectMap, "primaryUserAssignedIdentityId", s.PrimaryUserAssignedIdentityID)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "restrictOutboundNetworkAccess", s.RestrictOutboundNetworkAccess)
	populate(objectMap, "state", s.State)
	populate(objectMap, "version", s.Version)
	populate(objectMap, "workspaceFeature", s.WorkspaceFeature)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerTrustGroupProperties.
func (s ServerTrustGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupMembers", s.GroupMembers)
	populate(objectMap, "trustScopes", s.TrustScopes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerUpdate.
func (s ServerUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerUsage.
func (s *ServerUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &s.CurrentValue)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &s.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateTimeRFC3339(val, "NextResetTime", &s.NextResetTime)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &s.ResourceName)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncAgentProperties.
func (s SyncAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiryTime", s.ExpiryTime)
	populate(objectMap, "isUpToDate", s.IsUpToDate)
	populateTimeRFC3339(objectMap, "lastAliveTime", s.LastAliveTime)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "state", s.State)
	populate(objectMap, "syncDatabaseId", s.SyncDatabaseID)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncAgentProperties.
func (s *SyncAgentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &s.ExpiryTime)
			delete(rawMsg, key)
		case "isUpToDate":
			err = unpopulate(val, "IsUpToDate", &s.IsUpToDate)
			delete(rawMsg, key)
		case "lastAliveTime":
			err = unpopulateTimeRFC3339(val, "LastAliveTime", &s.LastAliveTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "syncDatabaseId":
			err = unpopulate(val, "SyncDatabaseID", &s.SyncDatabaseID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncFullSchemaProperties.
func (s *SyncFullSchemaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdateTime":
			err = unpopulateTimeRFC3339(val, "LastUpdateTime", &s.LastUpdateTime)
			delete(rawMsg, key)
		case "tables":
			err = unpopulate(val, "Tables", &s.Tables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroup.
func (s SyncGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncGroupLogProperties.
func (s *SyncGroupLogProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &s.Details)
			delete(rawMsg, key)
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &s.OperationStatus)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		case "tracingId":
			err = unpopulate(val, "TracingID", &s.TracingID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroupProperties.
func (s SyncGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "conflictLoggingRetentionInDays", s.ConflictLoggingRetentionInDays)
	populate(objectMap, "conflictResolutionPolicy", s.ConflictResolutionPolicy)
	populate(objectMap, "enableConflictLogging", s.EnableConflictLogging)
	populate(objectMap, "hubDatabasePassword", s.HubDatabasePassword)
	populate(objectMap, "hubDatabaseUserName", s.HubDatabaseUserName)
	populate(objectMap, "interval", s.Interval)
	populateTimeRFC3339(objectMap, "lastSyncTime", s.LastSyncTime)
	populate(objectMap, "privateEndpointName", s.PrivateEndpointName)
	populate(objectMap, "schema", s.Schema)
	populate(objectMap, "syncDatabaseId", s.SyncDatabaseID)
	populate(objectMap, "syncState", s.SyncState)
	populate(objectMap, "usePrivateLinkConnection", s.UsePrivateLinkConnection)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncGroupProperties.
func (s *SyncGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conflictLoggingRetentionInDays":
			err = unpopulate(val, "ConflictLoggingRetentionInDays", &s.ConflictLoggingRetentionInDays)
			delete(rawMsg, key)
		case "conflictResolutionPolicy":
			err = unpopulate(val, "ConflictResolutionPolicy", &s.ConflictResolutionPolicy)
			delete(rawMsg, key)
		case "enableConflictLogging":
			err = unpopulate(val, "EnableConflictLogging", &s.EnableConflictLogging)
			delete(rawMsg, key)
		case "hubDatabasePassword":
			err = unpopulate(val, "HubDatabasePassword", &s.HubDatabasePassword)
			delete(rawMsg, key)
		case "hubDatabaseUserName":
			err = unpopulate(val, "HubDatabaseUserName", &s.HubDatabaseUserName)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &s.Interval)
			delete(rawMsg, key)
		case "lastSyncTime":
			err = unpopulateTimeRFC3339(val, "LastSyncTime", &s.LastSyncTime)
			delete(rawMsg, key)
		case "privateEndpointName":
			err = unpopulate(val, "PrivateEndpointName", &s.PrivateEndpointName)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &s.Schema)
			delete(rawMsg, key)
		case "syncDatabaseId":
			err = unpopulate(val, "SyncDatabaseID", &s.SyncDatabaseID)
			delete(rawMsg, key)
		case "syncState":
			err = unpopulate(val, "SyncState", &s.SyncState)
			delete(rawMsg, key)
		case "usePrivateLinkConnection":
			err = unpopulate(val, "UsePrivateLinkConnection", &s.UsePrivateLinkConnection)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroupSchema.
func (s SyncGroupSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "masterSyncMemberName", s.MasterSyncMemberName)
	populate(objectMap, "tables", s.Tables)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroupSchemaTable.
func (s SyncGroupSchemaTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "columns", s.Columns)
	populate(objectMap, "quotedName", s.QuotedName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SyncMember.
func (s SyncMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualCluster.
func (v VirtualCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualClusterProperties.
func (v VirtualClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "childResources", v.ChildResources)
	populate(objectMap, "family", v.Family)
	populate(objectMap, "maintenanceConfigurationId", v.MaintenanceConfigurationID)
	populate(objectMap, "subnetId", v.SubnetID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VirtualClusterUpdate.
func (v VirtualClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentRecurringScansProperties.
func (v VulnerabilityAssessmentRecurringScansProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "emailSubscriptionAdmins", v.EmailSubscriptionAdmins)
	populate(objectMap, "emails", v.Emails)
	populate(objectMap, "isEnabled", v.IsEnabled)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentScanRecordProperties.
func (v VulnerabilityAssessmentScanRecordProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", v.EndTime)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "numberOfFailedSecurityChecks", v.NumberOfFailedSecurityChecks)
	populate(objectMap, "scanId", v.ScanID)
	populateTimeRFC3339(objectMap, "startTime", v.StartTime)
	populate(objectMap, "state", v.State)
	populate(objectMap, "storageContainerPath", v.StorageContainerPath)
	populate(objectMap, "triggerType", v.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentScanRecordProperties.
func (v *VulnerabilityAssessmentScanRecordProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &v.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "numberOfFailedSecurityChecks":
			err = unpopulate(val, "NumberOfFailedSecurityChecks", &v.NumberOfFailedSecurityChecks)
			delete(rawMsg, key)
		case "scanId":
			err = unpopulate(val, "ScanID", &v.ScanID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &v.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "storageContainerPath":
			err = unpopulate(val, "StorageContainerPath", &v.StorageContainerPath)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &v.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
