//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresql

import "time"

// CheckNameAvailabilityClientExecuteOptions contains the optional parameters for the CheckNameAvailabilityClient.Execute
// method.
type CheckNameAvailabilityClientExecuteOptions struct {
	// placeholder for future optional parameters
}

// CloudError - An error response from the Batch service.
type CloudError struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse `json:"error,omitempty"`
}

// Configuration - Represents a Configuration.
type Configuration struct {
	// The properties of a configuration.
	Properties *ConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigurationListResult - A list of server configurations.
type ConfigurationListResult struct {
	// The list of server configurations.
	Value []*Configuration `json:"value,omitempty"`
}

// ConfigurationProperties - The properties of a configuration.
type ConfigurationProperties struct {
	// Source of the configuration.
	Source *string `json:"source,omitempty"`

	// Value of the configuration.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string `json:"allowedValues,omitempty" azure:"ro"`

	// READ-ONLY; Data type of the configuration.
	DataType *string `json:"dataType,omitempty" azure:"ro"`

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string `json:"defaultValue,omitempty" azure:"ro"`

	// READ-ONLY; Description of the configuration.
	Description *string `json:"description,omitempty" azure:"ro"`
}

// ConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ConfigurationsClient.BeginCreateOrUpdate
// method.
type ConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationsClientGetOptions contains the optional parameters for the ConfigurationsClient.Get method.
type ConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientListByServerOptions contains the optional parameters for the ConfigurationsClient.ListByServer method.
type ConfigurationsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// Database - Represents a Database.
type Database struct {
	// The properties of a database.
	Properties *DatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseListResult - A List of databases.
type DatabaseListResult struct {
	// The list of databases housed in a server
	Value []*Database `json:"value,omitempty"`
}

// DatabaseProperties - The properties of a database.
type DatabaseProperties struct {
	// The charset of the database.
	Charset *string `json:"charset,omitempty"`

	// The collation of the database.
	Collation *string `json:"collation,omitempty"`
}

// DatabasesClientBeginCreateOrUpdateOptions contains the optional parameters for the DatabasesClient.BeginCreateOrUpdate
// method.
type DatabasesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginDeleteOptions contains the optional parameters for the DatabasesClient.BeginDelete method.
type DatabasesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientGetOptions contains the optional parameters for the DatabasesClient.Get method.
type DatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListByServerOptions contains the optional parameters for the DatabasesClient.ListByServer method.
type DatabasesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// FirewallRule - Represents a server firewall rule.
type FirewallRule struct {
	// REQUIRED; The properties of a firewall rule.
	Properties *FirewallRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FirewallRuleListResult - A list of firewall rules.
type FirewallRuleListResult struct {
	// The list of firewall rules in a server.
	Value []*FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties - The properties of a server firewall rule.
type FirewallRuleProperties struct {
	// REQUIRED; The end IP address of the server firewall rule. Must be IPv4 format.
	EndIPAddress *string `json:"endIpAddress,omitempty"`

	// REQUIRED; The start IP address of the server firewall rule. Must be IPv4 format.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// FirewallRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the FirewallRulesClient.BeginCreateOrUpdate
// method.
type FirewallRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallRulesClientBeginDeleteOptions contains the optional parameters for the FirewallRulesClient.BeginDelete method.
type FirewallRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallRulesClientGetOptions contains the optional parameters for the FirewallRulesClient.Get method.
type FirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientListByServerOptions contains the optional parameters for the FirewallRulesClient.ListByServer method.
type FirewallRulesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// LocationBasedPerformanceTierClientListOptions contains the optional parameters for the LocationBasedPerformanceTierClient.List
// method.
type LocationBasedPerformanceTierClientListOptions struct {
	// placeholder for future optional parameters
}

// LogFile - Represents a log file.
type LogFile struct {
	// The properties of the log file.
	Properties *LogFileProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogFileListResult - A list of log files.
type LogFileListResult struct {
	// The list of log files.
	Value []*LogFile `json:"value,omitempty"`
}

// LogFileProperties - The properties of a log file.
type LogFileProperties struct {
	// Size of the log file.
	SizeInKB *int64 `json:"sizeInKB,omitempty"`

	// Type of the log file.
	Type *string `json:"type,omitempty"`

	// The url to download the log file from.
	URL *string `json:"url,omitempty"`

	// READ-ONLY; Creation timestamp of the log file.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Last modified timestamp of the log file.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// LogFilesClientListByServerOptions contains the optional parameters for the LogFilesClient.ListByServer method.
type LogFilesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// NameAvailability - Represents a resource name availability.
type NameAvailability struct {
	// Error Message.
	Message *string `json:"message,omitempty"`

	// Indicates whether the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Reason for name being unavailable.
	Reason *string `json:"reason,omitempty"`
}

// NameAvailabilityRequest - Request from client to check resource name availability.
type NameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// Resource type used for verification.
	Type *string `json:"type,omitempty"`
}

// Operation - REST API operation definition.
type Operation struct {
	// READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly name for the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Operation resource provider name.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of resource provider operations.
type OperationListResult struct {
	// The list of resource provider operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PerformanceTierListResult - A list of performance tiers.
type PerformanceTierListResult struct {
	// The list of performance tiers
	Value []*PerformanceTierProperties `json:"value,omitempty"`
}

// PerformanceTierProperties - Performance tier properties
type PerformanceTierProperties struct {
	// ID of the performance tier.
	ID *string `json:"id,omitempty"`

	// Maximum Backup retention in days for the performance tier edition
	MaxBackupRetentionDays *int32 `json:"maxBackupRetentionDays,omitempty"`

	// Max storage allowed for a server.
	MaxLargeStorageMB *int32 `json:"maxLargeStorageMB,omitempty"`

	// Max storage allowed for a server.
	MaxStorageMB *int32 `json:"maxStorageMB,omitempty"`

	// Minimum Backup retention in days for the performance tier edition
	MinBackupRetentionDays *int32 `json:"minBackupRetentionDays,omitempty"`

	// Max storage allowed for a server.
	MinLargeStorageMB *int32 `json:"minLargeStorageMB,omitempty"`

	// Max storage allowed for a server.
	MinStorageMB *int32 `json:"minStorageMB,omitempty"`

	// Service level objectives associated with the performance tier
	ServiceLevelObjectives []*PerformanceTierServiceLevelObjectives `json:"serviceLevelObjectives,omitempty"`
}

// PerformanceTierServiceLevelObjectives - Service level objectives for performance tier.
type PerformanceTierServiceLevelObjectives struct {
	// Edition of the performance tier.
	Edition *string `json:"edition,omitempty"`

	// Hardware generation associated with the service level objective
	HardwareGeneration *string `json:"hardwareGeneration,omitempty"`

	// ID for the service level objective.
	ID *string `json:"id,omitempty"`

	// Maximum Backup retention in days for the performance tier edition
	MaxBackupRetentionDays *int32 `json:"maxBackupRetentionDays,omitempty"`

	// Max storage allowed for a server.
	MaxStorageMB *int32 `json:"maxStorageMB,omitempty"`

	// Minimum Backup retention in days for the performance tier edition
	MinBackupRetentionDays *int32 `json:"minBackupRetentionDays,omitempty"`

	// Max storage allowed for a server.
	MinStorageMB *int32 `json:"minStorageMB,omitempty"`

	// vCore associated with the service level objective
	VCore *int32 `json:"vCore,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginUpdateTagsOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginUpdateTags
// method.
type PrivateEndpointConnectionsClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByServerOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByServer
// method.
type PrivateEndpointConnectionsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource group id.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource `json:"value,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByServerOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByServer
// method.
type PrivateLinkResourcesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

type PrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoverableServerProperties - The recoverable server's properties.
type RecoverableServerProperties struct {
	// READ-ONLY; Edition of the performance tier.
	Edition *string `json:"edition,omitempty" azure:"ro"`

	// READ-ONLY; Hardware generation associated with the service level objective
	HardwareGeneration *string `json:"hardwareGeneration,omitempty" azure:"ro"`

	// READ-ONLY; The last available backup date time.
	LastAvailableBackupDateTime *string `json:"lastAvailableBackupDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The service level objective
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty" azure:"ro"`

	// READ-ONLY; vCore associated with the service level objective
	VCore *int32 `json:"vCore,omitempty" azure:"ro"`

	// READ-ONLY; The PostgreSQL version
	Version *string `json:"version,omitempty" azure:"ro"`
}

// RecoverableServerResource - A recoverable server resource.
type RecoverableServerResource struct {
	// Resource properties.
	Properties *RecoverableServerProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoverableServersClientGetOptions contains the optional parameters for the RecoverableServersClient.Get method.
type RecoverableServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicasClientListByServerOptions contains the optional parameters for the ReplicasClient.ListByServer method.
type ReplicasClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceIdentity - Azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal
	// for the resource.
	Type *IdentityType `json:"type,omitempty"`

	// READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory tenant id.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SKU - Billing information related properties of a server.
type SKU struct {
	// REQUIRED; The name of the sku, typically, tier + family + cores, e.g. BGen41, GPGen58.
	Name *string `json:"name,omitempty"`

	// The scale up/out capacity, representing server's compute units.
	Capacity *int32 `json:"capacity,omitempty"`

	// The family of hardware.
	Family *string `json:"family,omitempty"`

	// The size code, to be interpreted by resource as appropriate.
	Size *string `json:"size,omitempty"`

	// The tier of the particular SKU, e.g. Basic.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SecurityAlertPolicyProperties - Properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled.
	State *ServerSecurityAlertPolicyState `json:"state,omitempty"`

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly
	DisabledAlerts []*string `json:"disabledAlerts,omitempty"`

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string `json:"emailAddresses,omitempty"`

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// Server - Represents a server.
type Server struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Properties of the server.
	Properties *ServerProperties `json:"properties,omitempty"`

	// The SKU (pricing tier) of the server.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAdministratorProperties - The properties of an server Administrator.
type ServerAdministratorProperties struct {
	// REQUIRED; The type of administrator.
	AdministratorType *string `json:"administratorType,omitempty"`

	// REQUIRED; The server administrator login account name.
	Login *string `json:"login,omitempty"`

	// REQUIRED; The server administrator Sid (Secure ID).
	Sid *string `json:"sid,omitempty"`

	// REQUIRED; The server Active Directory Administrator tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// ServerAdministratorResource - Represents a and external administrator to be created.
type ServerAdministratorResource struct {
	// Properties of the server AAD administrator.
	Properties *ServerAdministratorProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAdministratorResourceListResult - The response to a list Active Directory Administrators request.
type ServerAdministratorResourceListResult struct {
	// The list of server Active Directory Administrators for the server.
	Value []*ServerAdministratorResource `json:"value,omitempty"`
}

// ServerAdministratorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerAdministratorsClient.BeginCreateOrUpdate
// method.
type ServerAdministratorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAdministratorsClientBeginDeleteOptions contains the optional parameters for the ServerAdministratorsClient.BeginDelete
// method.
type ServerAdministratorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAdministratorsClientGetOptions contains the optional parameters for the ServerAdministratorsClient.Get method.
type ServerAdministratorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerAdministratorsClientListOptions contains the optional parameters for the ServerAdministratorsClient.List method.
type ServerAdministratorsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServerBasedPerformanceTierClientListOptions contains the optional parameters for the ServerBasedPerformanceTierClient.List
// method.
type ServerBasedPerformanceTierClientListOptions struct {
	// placeholder for future optional parameters
}

// ServerForCreate - Represents a server to be created.
type ServerForCreate struct {
	// REQUIRED; The location the resource resides in.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the server.
	Properties ServerPropertiesForCreateClassification `json:"properties,omitempty"`

	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The SKU (pricing tier) of the server.
	SKU *SKU `json:"sku,omitempty"`

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServerKey - A PostgreSQL Server key.
type ServerKey struct {
	// Properties of the ServerKey Resource.
	Properties *ServerKeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of encryption protector used to protect the key.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerKeyListResult - A list of PostgreSQL Server keys.
type ServerKeyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of PostgreSQL Server keys.
	Value []*ServerKey `json:"value,omitempty" azure:"ro"`
}

// ServerKeyProperties - Properties for a key execution.
type ServerKeyProperties struct {
	// REQUIRED; The key type like 'AzureKeyVault'.
	ServerKeyType *ServerKeyType `json:"serverKeyType,omitempty"`

	// The URI of the key.
	URI *string `json:"uri,omitempty"`

	// READ-ONLY; The key creation date.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`
}

// ServerKeysClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerKeysClient.BeginCreateOrUpdate
// method.
type ServerKeysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerKeysClientBeginDeleteOptions contains the optional parameters for the ServerKeysClient.BeginDelete method.
type ServerKeysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerKeysClientGetOptions contains the optional parameters for the ServerKeysClient.Get method.
type ServerKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerKeysClientListOptions contains the optional parameters for the ServerKeysClient.List method.
type ServerKeysClientListOptions struct {
	// placeholder for future optional parameters
}

// ServerListResult - A list of servers.
type ServerListResult struct {
	// The list of servers
	Value []*Server `json:"value,omitempty"`
}

// ServerParametersClientBeginListUpdateConfigurationsOptions contains the optional parameters for the ServerParametersClient.BeginListUpdateConfigurations
// method.
type ServerParametersClientBeginListUpdateConfigurationsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerPrivateEndpointConnection - A private endpoint connection under a server
type ServerPrivateEndpointConnection struct {
	// READ-ONLY; Resource ID of the Private Endpoint Connection.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint connection properties
	Properties *ServerPrivateEndpointConnectionProperties `json:"properties,omitempty" azure:"ro"`
}

// ServerPrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type ServerPrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *ServerPrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *PrivateEndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type ServerPrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The private link service connection status.
	Status *PrivateLinkServiceConnectionStateStatus `json:"status,omitempty"`

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *PrivateLinkServiceConnectionStateActionsRequire `json:"actionsRequired,omitempty" azure:"ro"`
}

// ServerProperties - The properties of a server.
type ServerProperties struct {
	// The administrator's login name of a server. Can only be specified when the server is being created (and is required for
	// creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// Earliest restore point creation time (ISO8601 format)
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty"`

	// The fully qualified domain name of a server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption `json:"infrastructureEncryption,omitempty"`

	// The master server id of a replica server.
	MasterServerID *string `json:"masterServerId,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// The maximum number of replicas that a master server can have.
	ReplicaCapacity *int32 `json:"replicaCapacity,omitempty"`

	// The replication role of the server.
	ReplicationRole *string `json:"replicationRole,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// A state of a server that is visible to user.
	UserVisibleState *ServerState `json:"userVisibleState,omitempty"`

	// Server version.
	Version *ServerVersion `json:"version,omitempty"`

	// READ-ONLY; Status showing whether the server data encryption is enabled with customer-managed keys.
	ByokEnforcement *string `json:"byokEnforcement,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections on a server
	PrivateEndpointConnections []*ServerPrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// ServerPropertiesForCreateClassification provides polymorphic access to related types.
// Call the interface's GetServerPropertiesForCreate() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ServerPropertiesForCreate, *ServerPropertiesForDefaultCreate, *ServerPropertiesForGeoRestore, *ServerPropertiesForReplica,
// - *ServerPropertiesForRestore
type ServerPropertiesForCreateClassification interface {
	// GetServerPropertiesForCreate returns the ServerPropertiesForCreate content of the underlying type.
	GetServerPropertiesForCreate() *ServerPropertiesForCreate
}

// ServerPropertiesForCreate - The properties used to create a new server.
type ServerPropertiesForCreate struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption `json:"infrastructureEncryption,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// Server version.
	Version *ServerVersion `json:"version,omitempty"`
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForCreate.
func (s *ServerPropertiesForCreate) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return s
}

// ServerPropertiesForDefaultCreate - The properties used to create a new server.
type ServerPropertiesForDefaultCreate struct {
	// REQUIRED; The administrator's login name of a server. Can only be specified when the server is being created (and is required
	// for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// REQUIRED; The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption `json:"infrastructureEncryption,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// Server version.
	Version *ServerVersion `json:"version,omitempty"`
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForDefaultCreate.
func (s *ServerPropertiesForDefaultCreate) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		Version:                  s.Version,
		SSLEnforcement:           s.SSLEnforcement,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		InfrastructureEncryption: s.InfrastructureEncryption,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		StorageProfile:           s.StorageProfile,
		CreateMode:               s.CreateMode,
	}
}

// ServerPropertiesForGeoRestore - The properties used to create a new server by restoring to a different region from a geo
// replicated backup.
type ServerPropertiesForGeoRestore struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// REQUIRED; The source server id to restore from.
	SourceServerID *string `json:"sourceServerId,omitempty"`

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption `json:"infrastructureEncryption,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// Server version.
	Version *ServerVersion `json:"version,omitempty"`
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForGeoRestore.
func (s *ServerPropertiesForGeoRestore) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		Version:                  s.Version,
		SSLEnforcement:           s.SSLEnforcement,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		InfrastructureEncryption: s.InfrastructureEncryption,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		StorageProfile:           s.StorageProfile,
		CreateMode:               s.CreateMode,
	}
}

// ServerPropertiesForReplica - The properties to create a new replica.
type ServerPropertiesForReplica struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// REQUIRED; The master server id to create replica from.
	SourceServerID *string `json:"sourceServerId,omitempty"`

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption `json:"infrastructureEncryption,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// Server version.
	Version *ServerVersion `json:"version,omitempty"`
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForReplica.
func (s *ServerPropertiesForReplica) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		Version:                  s.Version,
		SSLEnforcement:           s.SSLEnforcement,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		InfrastructureEncryption: s.InfrastructureEncryption,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		StorageProfile:           s.StorageProfile,
		CreateMode:               s.CreateMode,
	}
}

// ServerPropertiesForRestore - The properties used to create a new server by restoring from a backup.
type ServerPropertiesForRestore struct {
	// REQUIRED; The mode to create a new server.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// REQUIRED; Restore point creation time (ISO8601 format), specifying the time to restore from.
	RestorePointInTime *time.Time `json:"restorePointInTime,omitempty"`

	// REQUIRED; The source server id to restore from.
	SourceServerID *string `json:"sourceServerId,omitempty"`

	// Status showing whether the server enabled infrastructure encryption.
	InfrastructureEncryption *InfrastructureEncryption `json:"infrastructureEncryption,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// Server version.
	Version *ServerVersion `json:"version,omitempty"`
}

// GetServerPropertiesForCreate implements the ServerPropertiesForCreateClassification interface for type ServerPropertiesForRestore.
func (s *ServerPropertiesForRestore) GetServerPropertiesForCreate() *ServerPropertiesForCreate {
	return &ServerPropertiesForCreate{
		Version:                  s.Version,
		SSLEnforcement:           s.SSLEnforcement,
		MinimalTLSVersion:        s.MinimalTLSVersion,
		InfrastructureEncryption: s.InfrastructureEncryption,
		PublicNetworkAccess:      s.PublicNetworkAccess,
		StorageProfile:           s.StorageProfile,
		CreateMode:               s.CreateMode,
	}
}

// ServerSecurityAlertPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerSecurityAlertPoliciesClient.BeginCreateOrUpdate
// method.
type ServerSecurityAlertPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerSecurityAlertPoliciesClientGetOptions contains the optional parameters for the ServerSecurityAlertPoliciesClient.Get
// method.
type ServerSecurityAlertPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerSecurityAlertPoliciesClientListByServerOptions contains the optional parameters for the ServerSecurityAlertPoliciesClient.ListByServer
// method.
type ServerSecurityAlertPoliciesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerSecurityAlertPolicy - A server security alert policy.
type ServerSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerSecurityAlertPolicyListResult - A list of the server's security alert policies.
type ServerSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// ServerUpdateParameters - Parameters allowed to update for a server.
type ServerUpdateParameters struct {
	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The properties that can be updated for a server.
	Properties *ServerUpdateParametersProperties `json:"properties,omitempty"`

	// The SKU (pricing tier) of the server.
	SKU *SKU `json:"sku,omitempty"`

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServerUpdateParametersProperties - The properties that can be updated for a server.
type ServerUpdateParametersProperties struct {
	// The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// Enforce a minimal Tls version for the server.
	MinimalTLSVersion *MinimalTLSVersionEnum `json:"minimalTlsVersion,omitempty"`

	// Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`

	// The replication role of the server.
	ReplicationRole *string `json:"replicationRole,omitempty"`

	// Enable ssl enforcement or not when connect to server.
	SSLEnforcement *SSLEnforcementEnum `json:"sslEnforcement,omitempty"`

	// Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// The version of a server.
	Version *ServerVersion `json:"version,omitempty"`
}

// ServersClientBeginCreateOptions contains the optional parameters for the ServersClient.BeginCreate method.
type ServersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginDeleteOptions contains the optional parameters for the ServersClient.BeginDelete method.
type ServersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginRestartOptions contains the optional parameters for the ServersClient.BeginRestart method.
type ServersClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginUpdateOptions contains the optional parameters for the ServersClient.BeginUpdate method.
type ServersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientGetOptions contains the optional parameters for the ServersClient.Get method.
type ServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListByResourceGroupOptions contains the optional parameters for the ServersClient.ListByResourceGroup method.
type ServersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListOptions contains the optional parameters for the ServersClient.List method.
type ServersClientListOptions struct {
	// placeholder for future optional parameters
}

// StorageProfile - Storage Profile properties of a server
type StorageProfile struct {
	// Backup retention days for the server.
	BackupRetentionDays *int32 `json:"backupRetentionDays,omitempty"`

	// Enable Geo-redundant or not for server backup.
	GeoRedundantBackup *GeoRedundantBackup `json:"geoRedundantBackup,omitempty"`

	// Enable Storage Auto Grow.
	StorageAutogrow *StorageAutogrow `json:"storageAutogrow,omitempty"`

	// Max storage allowed for a server.
	StorageMB *int32 `json:"storageMB,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkRule - A virtual network rule.
type VirtualNetworkRule struct {
	// Resource properties.
	Properties *VirtualNetworkRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkRuleListResult - A list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*VirtualNetworkRule `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworkRuleProperties - Properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// REQUIRED; The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`

	// Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`

	// READ-ONLY; Virtual Network Rule State
	State *VirtualNetworkRuleState `json:"state,omitempty" azure:"ro"`
}

// VirtualNetworkRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkRulesClient.BeginCreateOrUpdate
// method.
type VirtualNetworkRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkRulesClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkRulesClient.BeginDelete
// method.
type VirtualNetworkRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkRulesClientGetOptions contains the optional parameters for the VirtualNetworkRulesClient.Get method.
type VirtualNetworkRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkRulesClientListByServerOptions contains the optional parameters for the VirtualNetworkRulesClient.ListByServer
// method.
type VirtualNetworkRulesClientListByServerOptions struct {
	// placeholder for future optional parameters
}
