//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotsecurity

const (
	moduleName    = "armiotsecurity"
	moduleVersion = "v0.5.0"
)

// AuthorizedState - Authorized state of the device.
type AuthorizedState string

const (
	AuthorizedStateAuthorized   AuthorizedState = "Authorized"
	AuthorizedStateUnauthorized AuthorizedState = "Unauthorized"
)

// PossibleAuthorizedStateValues returns the possible values for the AuthorizedState const type.
func PossibleAuthorizedStateValues() []AuthorizedState {
	return []AuthorizedState{
		AuthorizedStateAuthorized,
		AuthorizedStateUnauthorized,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// Criticality - Device criticality.
type Criticality string

const (
	CriticalityHigh   Criticality = "High"
	CriticalityLow    Criticality = "Low"
	CriticalityNormal Criticality = "Normal"
)

// PossibleCriticalityValues returns the possible values for the Criticality const type.
func PossibleCriticalityValues() []Criticality {
	return []Criticality{
		CriticalityHigh,
		CriticalityLow,
		CriticalityNormal,
	}
}

// DeviceDataSource - Device data source
type DeviceDataSource string

const (
	DeviceDataSourceCorpSensor DeviceDataSource = "CorpSensor"
	DeviceDataSourceMde        DeviceDataSource = "Mde"
	DeviceDataSourceMicroAgent DeviceDataSource = "MicroAgent"
	DeviceDataSourceOtSensor   DeviceDataSource = "OtSensor"
	DeviceDataSourceOther      DeviceDataSource = "Other"
)

// PossibleDeviceDataSourceValues returns the possible values for the DeviceDataSource const type.
func PossibleDeviceDataSourceValues() []DeviceDataSource {
	return []DeviceDataSource{
		DeviceDataSourceCorpSensor,
		DeviceDataSourceMde,
		DeviceDataSourceMicroAgent,
		DeviceDataSourceOtSensor,
		DeviceDataSourceOther,
	}
}

// DeviceStatus - Device status.
type DeviceStatus string

const (
	DeviceStatusActive   DeviceStatus = "Active"
	DeviceStatusDeleted  DeviceStatus = "Deleted"
	DeviceStatusInactive DeviceStatus = "Inactive"
	DeviceStatusRemoved  DeviceStatus = "Removed"
)

// PossibleDeviceStatusValues returns the possible values for the DeviceStatus const type.
func PossibleDeviceStatusValues() []DeviceStatus {
	return []DeviceStatus{
		DeviceStatusActive,
		DeviceStatusDeleted,
		DeviceStatusInactive,
		DeviceStatusRemoved,
	}
}

// MacCertainty - Indicates whether the association of the mac to the ip address is certain or a guess.
type MacCertainty string

const (
	MacCertaintyCertain MacCertainty = "Certain"
	MacCertaintyGuess   MacCertainty = "Guess"
)

// PossibleMacCertaintyValues returns the possible values for the MacCertainty const type.
func PossibleMacCertaintyValues() []MacCertainty {
	return []MacCertainty{
		MacCertaintyCertain,
		MacCertaintyGuess,
	}
}

// MdeIntegration - Integration status
type MdeIntegration string

const (
	MdeIntegrationDisabled MdeIntegration = "Disabled"
	MdeIntegrationEnabled  MdeIntegration = "Enabled"
)

// PossibleMdeIntegrationValues returns the possible values for the MdeIntegration const type.
func PossibleMdeIntegrationValues() []MdeIntegration {
	return []MdeIntegration{
		MdeIntegrationDisabled,
		MdeIntegrationEnabled,
	}
}

// OnboardingKind - The kind of onboarding for the subscription
type OnboardingKind string

const (
	OnboardingKindDefault         OnboardingKind = "Default"
	OnboardingKindEvaluation      OnboardingKind = "Evaluation"
	OnboardingKindMigratedToAzure OnboardingKind = "MigratedToAzure"
	OnboardingKindPurchased       OnboardingKind = "Purchased"
)

// PossibleOnboardingKindValues returns the possible values for the OnboardingKind const type.
func PossibleOnboardingKindValues() []OnboardingKind {
	return []OnboardingKind{
		OnboardingKindDefault,
		OnboardingKindEvaluation,
		OnboardingKindMigratedToAzure,
		OnboardingKindPurchased,
	}
}

// OnboardingStatus - Device onboarding status.
type OnboardingStatus string

const (
	OnboardingStatusInsufficientInfo OnboardingStatus = "InsufficientInfo"
	OnboardingStatusNotOnboarded     OnboardingStatus = "NotOnboarded"
	OnboardingStatusNotSupported     OnboardingStatus = "NotSupported"
	OnboardingStatusOnboarded        OnboardingStatus = "Onboarded"
)

// PossibleOnboardingStatusValues returns the possible values for the OnboardingStatus const type.
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return []OnboardingStatus{
		OnboardingStatusInsufficientInfo,
		OnboardingStatusNotOnboarded,
		OnboardingStatusNotSupported,
		OnboardingStatusOnboarded,
	}
}

// ProgrammingState - Indicates whether this device is programming
type ProgrammingState string

const (
	ProgrammingStateNotProgrammingDevice ProgrammingState = "NotProgrammingDevice"
	ProgrammingStateProgrammingDevice    ProgrammingState = "ProgrammingDevice"
)

// PossibleProgrammingStateValues returns the possible values for the ProgrammingState const type.
func PossibleProgrammingStateValues() []ProgrammingState {
	return []ProgrammingState{
		ProgrammingStateNotProgrammingDevice,
		ProgrammingStateProgrammingDevice,
	}
}

// PurdueLevel - Purdue level of the device.
type PurdueLevel string

const (
	PurdueLevelEnterprise     PurdueLevel = "Enterprise"
	PurdueLevelProcessControl PurdueLevel = "ProcessControl"
	PurdueLevelSupervisory    PurdueLevel = "Supervisory"
)

// PossiblePurdueLevelValues returns the possible values for the PurdueLevel const type.
func PossiblePurdueLevelValues() []PurdueLevel {
	return []PurdueLevel{
		PurdueLevelEnterprise,
		PurdueLevelProcessControl,
		PurdueLevelSupervisory,
	}
}

// SensorStatus - Status of the IoT sensor
type SensorStatus string

const (
	SensorStatusDisconnected SensorStatus = "Disconnected"
	SensorStatusOk           SensorStatus = "Ok"
	SensorStatusUnavailable  SensorStatus = "Unavailable"
)

// PossibleSensorStatusValues returns the possible values for the SensorStatus const type.
func PossibleSensorStatusValues() []SensorStatus {
	return []SensorStatus{
		SensorStatusDisconnected,
		SensorStatusOk,
		SensorStatusUnavailable,
	}
}

// SensorType - Type of sensor
type SensorType string

const (
	SensorTypeEnterprise SensorType = "Enterprise"
	SensorTypeOt         SensorType = "Ot"
)

// PossibleSensorTypeValues returns the possible values for the SensorType const type.
func PossibleSensorTypeValues() []SensorType {
	return []SensorType{
		SensorTypeEnterprise,
		SensorTypeOt,
	}
}

// SlotType - Slot type.
type SlotType string

const (
	SlotTypeAnalogIO    SlotType = "AnalogIO"
	SlotTypeCPU         SlotType = "Cpu"
	SlotTypeCommAdapter SlotType = "CommAdapter"
	SlotTypeDigitalIO   SlotType = "DigitalIO"
	SlotTypeGeneric     SlotType = "Generic"
	SlotTypeHmi         SlotType = "Hmi"
	SlotTypeSupply      SlotType = "Supply"
)

// PossibleSlotTypeValues returns the possible values for the SlotType const type.
func PossibleSlotTypeValues() []SlotType {
	return []SlotType{
		SlotTypeAnalogIO,
		SlotTypeCPU,
		SlotTypeCommAdapter,
		SlotTypeDigitalIO,
		SlotTypeGeneric,
		SlotTypeHmi,
		SlotTypeSupply,
	}
}

// TiStatus - TI Status of the IoT sensor
type TiStatus string

const (
	TiStatusFailed          TiStatus = "Failed"
	TiStatusInProgress      TiStatus = "InProgress"
	TiStatusOk              TiStatus = "Ok"
	TiStatusUpdateAvailable TiStatus = "UpdateAvailable"
)

// PossibleTiStatusValues returns the possible values for the TiStatus const type.
func PossibleTiStatusValues() []TiStatus {
	return []TiStatus{
		TiStatusFailed,
		TiStatusInProgress,
		TiStatusOk,
		TiStatusUpdateAvailable,
	}
}

// VersionKind - Kind of the version
type VersionKind string

const (
	VersionKindLatest   VersionKind = "Latest"
	VersionKindPreview  VersionKind = "Preview"
	VersionKindPrevious VersionKind = "Previous"
)

// PossibleVersionKindValues returns the possible values for the VersionKind const type.
func PossibleVersionKindValues() []VersionKind {
	return []VersionKind{
		VersionKindLatest,
		VersionKindPreview,
		VersionKindPrevious,
	}
}
