/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2012 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <string.h>
/* For getuid */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>

#include "gettext.h"
#include "support.h"
#include "create_main_window.h"
#include "gadmin-openvpn.h"
#include "widgets.h"
#include "commands.h"
#include "functions.h"
#include "status_update.h"
#include "set_version.h"
#include "create_client_tab.h"
#include "create_client_settings.h"
#include "create_log_tab.h"
#include "create_conf_tab.h"
#include "populate_gadmin_openvpn.h"
#include "show_info.h"

int MAX_READ_POPEN = 16384;
int activated = 0;
int use_tls = 0;

int info_window_exit_main = 0;

char global_user_name[1024]="";

gchar *selected_connection;



int main(int argc, char *argv[])
{
    int i = 0;
    gchar *info; //, *utf8;
    gchar *openvpn_client_dir;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);

    wid* widgets = g_malloc(sizeof(wid));

    /* Non root usage */
    if( ! getuid() == 0 )
    {
        /* For setting a different exit method in the info window */
        info_window_exit_main = 1;

        info = g_strdup_printf("You must be root to run: %s\nThis window will close in 10 seconds.\n", PACKAGE);
        show_info(info);
        g_free(info);

        /* Users can close the info window earlier then the timeout */
        for(i=0; i<10; i++)
        {
            while(gtk_events_pending())
                gtk_main_iteration();

            /* Set when close info window is clicked */
            if( info_window_exit_main == 2 )
                break;

            usleep(100000*10);
        }

        g_free(widgets);
        return 0;
    }


    /* Create the main window */
    create_main_window(widgets);

    /* Set OpenVPN version */
    set_version(widgets);

    /* Create the client tab */
    create_client_tab(widgets);

    /* Create the client settings */
    create_client_settings(widgets);

    /* Create the log tab */
    create_log_tab(widgets);

    /* Create the conf tab */
    create_conf_tab(widgets);


    /* Create the gadmin-openvpn directory if it doesnt exist */
    openvpn_client_dir = g_strdup_printf("%s", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_client_dir) )
      make_dir_chmod(openvpn_client_dir, "600"); /* Only accessible by root */
    g_free(openvpn_client_dir);

    /* Create the openvpn client directory if it doesnt exist */
    openvpn_client_dir = g_strdup_printf("%s/client", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(openvpn_client_dir) )
      make_dir_chmod(openvpn_client_dir, "600"); /* Only accessible by root */
    g_free(openvpn_client_dir);


    /* Populate the entire gui */
    populate_gadmin_openvpn(widgets);

    /* Window close button (x) */   
    g_signal_connect(GTK_OBJECT(widgets->main_window), "destroy",
                 GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    gtk_timeout_add(1000, (GtkFunction) status_update, widgets);

    gtk_main();

    if( selected_connection!=NULL )
      g_free(selected_connection);

    g_free(widgets);

    return 0;
}
