# Ограничения на сложность запроса

Ограничения на сложность запроса - часть настроек.
Используются, чтобы обеспечить более безопасное исполнение запросов из пользовательского интерфейса.
Почти все ограничения действуют только на SELECT-ы.
При распределённой обработке запроса, ограничения действуют на каждом сервере по-отдельности.

Ограничения проверяются на каждый блок обработанных данных, а не на каждую строку. В связи с этим, ограничения могут быть превышены на размер блока.

Ограничения вида "максимальное количество чего-нибудь" могут принимать значение 0, которое обозначает "не ограничено".
Для большинства ограничений также присутствует настройка вида overflow_mode - что делать, когда ограничение превышено.
Оно может принимать одно из двух значений: `throw` или `break`; а для ограничения на агрегацию (group_by_overflow_mode) есть ещё значение `any`.

`throw` - кинуть исключение (по умолчанию).

`break` - прервать выполнение запроса и вернуть неполный результат, как будто исходные данные закончились.

`any (только для group_by_overflow_mode)` - продолжить агрегацию по ключам, которые успели войти в набор, но не добавлять новые ключи в набор.

<a name="settings_max_memory_usage"></a>

## max_memory_usage

Максимальный возможный объем оперативной памяти для выполнения запроса на одном сервере.

В конфигурационном файле по умолчанию, ограничение равно 10 ГБ.

Настройка не учитывает объём свободной памяти или общий объём памяти на машине.
Ограничение действует на один запрос, в пределах одного сервера.
Текущее потребление памяти для каждого запроса можно посмотреть с помощью `SHOW PROCESSLIST`.
Также отслеживается и выводится в лог пиковое потребление памяти для каждого запроса.

Потребление памяти не отслеживается для состояний некоторых агрегатных функций.

Потребление памяти не полностью учитывается для состояний агрегатных функций `min`, `max`, `any`, `anyLast`, `argMin`, `argMax` от аргументов `String` и `Array`.

Потребление памяти ограничивается также параметрами `max_memory_usage_for_user` и `max_memory_usage_for_all_queries`.

## max_memory_usage_for_user

Максимальный возможный объем оперативной памяти для запросов пользователя на одном сервере.

Значения по умолчанию определены в файле [Settings.h](https://github.com/yandex/ClickHouse/blob/master/dbms/src/Interpreters/Settings.h#L244). По умолчанию размер не ограничен (`max_memory_usage_for_user = 0`).

Смотрите также описание настройки [max_memory_usage](#settings_max_memory_usage).

## max_memory_usage_for_all_queries

Максимальный возможный объем оперативной памяти для всех запросов на одном сервере.

Значения по умолчанию определены в файле [Settings.h](https://github.com/yandex/ClickHouse/blob/master/dbms/src/Interpreters/Settings.h#L245). По умолчанию размер не ограничен (`max_memory_usage_for_all_queries = 0`).

Смотрите также описание настройки [max_memory_usage](#settings_max_memory_usage).

## max_rows_to_read

Следующие ограничения могут проверяться на каждый блок (а не на каждую строку). То есть, ограничения могут быть немного нарушены.
При выполнении запроса в несколько потоков, следующие ограничения действуют в каждом потоке по-отдельности.

Максимальное количество строчек, которое можно прочитать из таблицы при выполнении запроса.

## max_bytes_to_read

Максимальное количество байт (несжатых данных), которое можно прочитать из таблицы при выполнении запроса.

## read_overflow_mode

Что делать, когда количество прочитанных данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_to_group_by

Максимальное количество уникальных ключей, получаемых в процессе агрегации. Позволяет ограничить потребление оперативки при агрегации.

## group_by_overflow_mode

Что делать, когда количество уникальных ключей при агрегации превысило ограничение: throw, break или any. По умолчанию: throw.
Использование значения any позволяет выполнить GROUP BY приближённо. Качество такого приближённого вычисления сильно зависит от статистических свойств данных.

## max_rows_to_sort

Максимальное количество строк до сортировки. Позволяет ограничить потребление оперативки при сортировке.

## max_bytes_to_sort

Максимальное количество байт до сортировки.

## sort_overflow_mode

Что делать, если количество строк, полученное перед сортировкой, превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_result_rows

Ограничение на количество строк результата. Проверяются также для подзапросов и на удалённых серверах при выполнении части распределённого запроса.

## max_result_bytes

Ограничение на количество байт результата. Аналогично.

## result_overflow_mode

Что делать, если объём результата превысил одно из ограничений: throw или break. По умолчанию: throw.
Использование break по смыслу похоже на LIMIT.

## max_execution_time

Максимальное время выполнения запроса в секундах.
На данный момент не проверяется при одной из стадий сортировки а также при слиянии и финализации агрегатных функций.

## timeout_overflow_mode

Что делать, если запрос выполняется дольше max_execution_time: throw или break. По умолчанию: throw.

## min_execution_speed

Минимальная скорость выполнения запроса в строчках в секунду. Проверяется на каждый блок данных по истечении timeout_before_checking_execution_speed. Если скорость выполнения запроса оказывается меньше, то кидается исключение.

## timeout_before_checking_execution_speed

Проверять, что скорость выполнения запроса не слишком низкая (не меньше min_execution_speed), после прошествия указанного времени в секундах.

## max_columns_to_read

Максимальное количество столбцов, которых можно читать из таблицы в одном запросе. Если запрос требует чтения большего количества столбцов - кинуть исключение.

## max_temporary_columns

Максимальное количество временных столбцов, которых необходимо одновременно держать в оперативке, в процессе выполнения запроса, включая константные столбцы. Если временных столбцов оказалось больше - кидается исключение.

## max_temporary_non_const_columns

То же самое, что и max_temporary_columns, но без учёта столбцов-констант.
Стоит заметить, что столбцы-константы довольно часто образуются в процессе выполнения запроса, но расходуют примерно нулевое количество вычислительных ресурсов.

## max_subquery_depth

Максимальная вложенность подзапросов. Если подзапросы более глубокие - кидается исключение. По умолчанию: 100.

## max_pipeline_depth

Максимальная глубина конвейера выполнения запроса. Соответствует количеству преобразований, которое проходит каждый блок данных в процессе выполнения запроса. Считается в пределах одного сервера. Если глубина конвейера больше - кидается исключение. По умолчанию: 1000.

## max_ast_depth

Максимальная вложенность синтаксического дерева запроса. Если превышена - кидается исключение.
На данный момент, проверяются не во время парсинга а уже после парсинга запроса. То есть, во время парсинга может быть создано слишком глубокое синтаксическое дерево, но запрос не будет выполнен. По умолчанию: 1000.

## max_ast_elements

Максимальное количество элементов синтаксического дерева запроса. Если превышено - кидается исключение.
Аналогично, проверяется уже после парсинга запроса. По умолчанию: 10 000.

## max_rows_in_set

Максимальное количество строчек для множества в секции IN, создаваемого из подзапроса.

## max_bytes_in_set

Максимальное количество байт (несжатых данных), занимаемое множеством в секции IN, создаваемым из подзапроса.

## set_overflow_mode

Что делать, когда количество данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_in_distinct

Максимальное количество различных строчек при использовании DISTINCT.

## max_bytes_in_distinct

Максимальное количество байт, занимаемых хэш-таблицей, при использовании DISTINCT.

## distinct_overflow_mode

Что делать, когда количество данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_to_transfer

Максимальное количество строчек, которых можно передать на удалённый сервер или сохранить во временную таблицу, при использовании GLOBAL IN.

## max_bytes_to_transfer

Максимальное количество байт (несжатых данных), которых можно передать на удалённый сервер или сохранить во временную таблицу, при использовании GLOBAL IN.

## transfer_overflow_mode

Что делать, когда количество данных превысило одно из ограничений: throw или break. По умолчанию: throw.

[Оригинальная статья](https://clickhouse.yandex/docs/ru/operations/settings/query_complexity/) <!--hide-->
