### www.sgml.mk -- Production HTML via SGML

# Author: Michael Grünewald
# Date: Jeu 13 mar 2008 21:58:28 CET
# Cookie: SYNOPSIS TARGET VARIABLE EN DOCUMENTATION

# BSD Owl Scripts (https://bitbucket.org/michipili/bsdowl)
# This file is part of BSD Owl Scripts
#
# Copyright © 2005–2014 Michael Grünewald
#
# This file must be used under the terms of the CeCILL-B.
# This source file is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at
# http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt


### SYNOPSIS

# Attention: il ne s'agit pas d'un système DOCBOOK!

# WWW = index.html
# SRCS = index.sgml
# SRCS+= head-css.sgml
# SRCS+= head-title.sgml
# SRCS+= body-content.sgml
# SRCS+= body-nav.sgml
#
# WWWDIR = ${WWWBASE}/subdir
#
# .include "www.sgml.mk"



#
# Description des variables
#

# WWW
#
#   Énumère les fichiers à produire à partir des sources SGML
#
#   Chaque terme a sa propre variable SRCS, et la variable SRCS
#   générale y est ajoutée.


# WWWMAIN
#
#    Nom du fichier principal
#
#    Pour produire plusieurs fichiers, il faut utiliser la forme
#    spécialisée de cette variable.


# WWWBASE
#
#   Répertoire racine du document cible (la version installée)
#
#   Lorsque cette variable a une valeur, cette valeur est transmise
#   aux sous-processus MAKE, de cette façon elle peut être utilisée
#   pour définir correctement WWWDIR.

# WWWOWN, WWWGRP, WWWMODE, WWWDIR
#
#   Paramètres de la procédure d'installation
#
#   Ces paramètres sont documentés dans le module bps.files.mk.

# INCLUDE
#
#   Énumère les entités à inclure
#
#   Il s'agit des entités de type paramètre dont la valeur doit être
#   positionnée à INCLUDE.

# DIRS
#
#   Énumère les dossiers de recherche

# CATALOG
#
#   Énumère les catalogues à inclure pour la résolution des entités

.include "bps.init.mk"

.SUFFIXES: .sgml

WWWNORMALIZE?= osgmlnorm -d
WWWINPUT?= ascii
WWWTIDY?= tidy4 -q -${WWWINPUT}

.for variable in DIRS CATALOG INCLUDE
.if defined(${variable})&&!empty(${variable})
.MAKEFLAGS: ${variable}='${${variable}}'
.else
${variable}=
.endif
.endfor

WWWNORMALIZETOOL = ${WWWNORMALIZE}
.for dir in ${DIRS}
WWWNORMALIZETOOL+= -D${dir}
.PATH.sgml: ${dir}
.endfor
.for catalog in ${CATALOG}
WWWNORMALIZETOOL+= -c${catalog}
.endfor
.for include in ${INCLUDE}
WWWNORMALIZETOOL+= -i${include}
.endfor

.for file in ${WWW}
.if defined(WWWMAIN)&&!empty(WWWMAIN)
WWWMAIN.${file:T} = ${WWWMAIN}
.endif
.if !defined(WWWMAIN.${file:T}) && exists(${file:.html=.sgml})
WWWMAIN.${file:T} = ${file:.html=.sgml}
.endif
.if !defined(WWWMAIN.${file:T}) || empty(WWWMAIN.${file:T})
.error "No main file for ${file}"
.endif
SRCS.${file:T}?= ${WWWMAIN.${file:T}}
.if empty(SRCS.${file:T}:M${WWWMAIN.${file:T}})
SRCS.${file:T}+= ${WWWMAIN.${file:T}}
.endif
.endfor

.if defined(SRCS)&!empty(SRCS)
.for file in ${WWW}
SRCS.${file:T}+= ${SRCS}
.endfor
.endif

.for file in ${WWW}
CLEANFILES+= ${file}
.if exists(${file}.pre)
CLEANFILES += ${file}.pre
.endif
${file}: ${SRCS.${file:T}}
	${WWWNORMALIZETOOL} ${WWWMAIN.${file:T}} | ${WWWTIDY} > ${.TARGET}.pre
	${MV} ${.TARGET}.pre ${.TARGET}
.endfor

.include "www.files.mk"

### End of file `www.files.mk'
