/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _radar_h
#define _radar_h

#include "pm.h"

#ifdef radar_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Set the display of the "radar" panel slot.
 * @param c
 * @param mode One of the RM_* constants.
 */
EXTERN void radar_setMode(craft * c, int mode);

/**
 * Compute how much radar energy the emitter craft puts on each other player
 * and which other players are visible in the radar of the emitter.
 * Calculates: [craft].rinfo (visible targets) and [craft].rval (received energy
 * from each other player).
 * @param emitter
 */
void radar_calculateEmissions(craft * emitter);

EXTERN void radar_droneUpdate(craft * c);

/**
 * Draw the radar display or do nothing if radar disabled
 */
EXTERN void radar_update(craft * c, viewer * u);

/*
 * Draw the TEWS display or do nothing if radar disabled
 */
EXTERN void radar_updateTEWS(craft * c, viewer * u);

/*
 * Get a new radar target
 */
EXTERN int radar_getNewTarget(craft * c);

#undef EXTERN
#endif
