# extract the content of an archive using unzip
# USAGE: archive_extraction_using_unzip $archive $destination_directory $log_file
archive_extraction_using_unzip() {
	local archive destination_directory log_file
	archive="$1"
	destination_directory="$2"
	log_file="$3"

	local archive_path
	archive_path=$(archive_path "$archive")

	local extractor_options
	extractor_options=$(archive_extractor_options "$archive")
	if [ -z "$extractor_options" ]; then
		## unzip -o: overwrite existing files without prompting.
		extractor_options='-o'
	fi
	if ! {
		printf 'unzip %s -d "%s" "%s"\n' "$extractor_options" "$destination_directory" "$archive_path"
		unzip $extractor_options -d "$destination_directory" "$archive_path" 2>&1
	} >> "$log_file"
	then
		error_archive_extraction_failure "$archive"
		return 1
	fi
}

