#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Prophour23
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250130.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='prophour23'
GAME_NAME='Prophour23'

ARCHIVE_BASE_0_NAME='Prophour23_Linux32_1.1.2.zip'
ARCHIVE_BASE_0_MD5='57c6a33a788647526f25d88aeb355ad6'
ARCHIVE_BASE_0_VERSION='1.1.2-humble1'
ARCHIVE_BASE_0_SIZE='101779'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/prophour23'

CONTENT_PATH_DEFAULT='Prophour23_Linux32_1.1.2'
CONTENT_GAME_MAIN_FILES='
prophour23.jar'

APP_MAIN_TYPE='java'
APP_MAIN_EXE='prophour23.jar'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_16 APP_MAIN_ICON_32 APP_MAIN_ICON_128 APP_MAIN_ICON_256'
APP_MAIN_ICON_16='icon-16.png'
APP_MAIN_ICON_32='icon-32.png'
APP_MAIN_ICON_128='icon-128.png'
APP_MAIN_ICON_256='icon.png'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
